/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.health;

import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.StringUtils;

public class SimpleHealthIndicator
implements HealthIndicator<Map<String, Object>>,
EnvironmentAware {
    private Environment environment;
    private DataSource dataSource;
    private JdbcTemplate jdbcTemplate;
    private String query = "SELECT 'Hello'";

    @Override
    public Map<String, Object> health() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("status", "ok");
        if (this.dataSource != null) {
            try {
                map.put("database", this.dataSource.getConnection().getMetaData().getDatabaseProductName());
            }
            catch (SQLException e) {
                map.put("status", "error");
                map.put("error", e.getClass().getName() + ": " + e.getMessage());
            }
            if (StringUtils.hasText((String)this.query)) {
                try {
                    map.put("hello", this.jdbcTemplate.queryForObject(this.query, String.class));
                }
                catch (Exception e) {
                    map.put("status", "error");
                    map.put("error", e.getClass().getName() + ": " + e.getMessage());
                }
            }
        }
        if (this.environment != null) {
            map.put("spring.profiles.active", StringUtils.arrayToCommaDelimitedString((Object[])this.environment.getActiveProfiles()));
        }
        return map;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    public void setQuery(String query) {
        this.query = query;
    }
}

