/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.mvc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.boot.actuate.endpoint.ActionEndpoint;
import org.springframework.boot.actuate.endpoint.Endpoint;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.HandlerExecutionChain;
import org.springframework.web.servlet.handler.AbstractUrlHandlerMapping;

public class EndpointHandlerMapping
extends AbstractUrlHandlerMapping
implements InitializingBean,
ApplicationContextAware {
    private List<Endpoint<?>> endpoints;
    private String prefix = "";
    private boolean disabled = false;

    public EndpointHandlerMapping() {
        this.setOrder(Integer.MIN_VALUE);
    }

    public EndpointHandlerMapping(Collection<? extends Endpoint<?>> endpoints) {
        Assert.notNull(endpoints, (String)"Endpoints must not be null");
        this.endpoints = new ArrayList(endpoints);
    }

    public void afterPropertiesSet() throws Exception {
        if (this.endpoints == null) {
            this.endpoints = this.findEndpointBeans();
        }
        if (!this.disabled) {
            for (Endpoint<?> endpoint : this.endpoints) {
                this.registerHandler(this.prefix + endpoint.getPath(), endpoint);
            }
        }
    }

    private List<Endpoint<?>> findEndpointBeans() {
        return new ArrayList(BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.getApplicationContext(), Endpoint.class).values());
    }

    protected Object lookupHandler(String urlPath, HttpServletRequest request) throws Exception {
        Object handler = super.lookupHandler(urlPath, request);
        if (handler != null) {
            String method;
            Object endpoint = handler instanceof HandlerExecutionChain ? ((HandlerExecutionChain)handler).getHandler() : handler;
            String string = method = endpoint instanceof ActionEndpoint ? "POST" : "GET";
            if (request.getMethod().equals(method)) {
                return endpoint;
            }
        }
        return null;
    }

    public void setPrefix(String prefix) {
        Assert.isTrue(("".equals(prefix) || StringUtils.startsWithIgnoreCase((String)prefix, (String)"/") ? 1 : 0) != 0, (String)"prefix must start with '/'");
        this.prefix = prefix;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public List<Endpoint<?>> getEndpoints() {
        return Collections.unmodifiableList(this.endpoints);
    }
}

