/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.mvc;

import com.fasterxml.jackson.databind.SerializationFeature;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.actuate.endpoint.Endpoint;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.accept.ContentNegotiationManager;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.servlet.HandlerAdapter;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurationSupport;

public final class EndpointHandlerAdapter
implements HandlerAdapter {
    private final Log logger = LogFactory.getLog(this.getClass());
    private static final MediaType MEDIA_TYPE_APPLICATION = new MediaType("application");
    private ContentNegotiationManager contentNegotiationManager = new ContentNegotiationManager();
    private List<HttpMessageConverter<?>> messageConverters;
    private List<MediaType> allSupportedMediaTypes;

    public EndpointHandlerAdapter() {
        WebMvcConfigurationSupportConventions conventions = new WebMvcConfigurationSupportConventions();
        this.setMessageConverters(conventions.getDefaultHttpMessageConverters());
    }

    public boolean supports(Object handler) {
        return handler instanceof Endpoint;
    }

    public long getLastModified(HttpServletRequest request, Object handler) {
        return -1L;
    }

    public ModelAndView handle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        this.handle(request, response, (Endpoint)handler);
        return null;
    }

    private void handle(HttpServletRequest request, HttpServletResponse response, Endpoint<?> endpoint) throws Exception {
        Object result = endpoint.invoke();
        Class<?> resultClass = result.getClass();
        List<MediaType> mediaTypes = this.getMediaTypes(request, endpoint, resultClass);
        MediaType selectedMediaType = this.selectMediaType(mediaTypes);
        ServletServerHttpResponse outputMessage = new ServletServerHttpResponse(response);
        try {
            if (selectedMediaType != null) {
                selectedMediaType = selectedMediaType.removeQualityValue();
                for (HttpMessageConverter<?> messageConverter : this.messageConverters) {
                    if (!messageConverter.canWrite(resultClass, selectedMediaType)) continue;
                    messageConverter.write(result, selectedMediaType, (HttpOutputMessage)outputMessage);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Written [" + result + "] as \"" + selectedMediaType + "\" using [" + messageConverter + "]"));
                    }
                    return;
                }
            }
            throw new HttpMediaTypeNotAcceptableException(this.allSupportedMediaTypes);
        }
        finally {
            outputMessage.close();
        }
    }

    private List<MediaType> getMediaTypes(HttpServletRequest request, Endpoint<?> endpoint, Class<?> resultClass) throws HttpMediaTypeNotAcceptableException {
        List<MediaType> requested = this.getAcceptableMediaTypes(request);
        List<MediaType> producible = this.getProducibleMediaTypes(endpoint, resultClass);
        LinkedHashSet<MediaType> compatible = new LinkedHashSet<MediaType>();
        for (MediaType r : requested) {
            for (MediaType p : producible) {
                if (!r.isCompatibleWith(p)) continue;
                compatible.add(this.getMostSpecificMediaType(r, p));
            }
        }
        if (compatible.isEmpty()) {
            throw new HttpMediaTypeNotAcceptableException(producible);
        }
        ArrayList<MediaType> mediaTypes = new ArrayList<MediaType>(compatible);
        MediaType.sortBySpecificityAndQuality(mediaTypes);
        return mediaTypes;
    }

    private List<MediaType> getAcceptableMediaTypes(HttpServletRequest request) throws HttpMediaTypeNotAcceptableException {
        List<MediaType> mediaTypes = this.contentNegotiationManager.resolveMediaTypes((NativeWebRequest)new ServletWebRequest(request));
        return mediaTypes.isEmpty() ? Collections.singletonList(MediaType.ALL) : mediaTypes;
    }

    private List<MediaType> getProducibleMediaTypes(Endpoint<?> endpoint, Class<?> returnValueClass) {
        MediaType[] mediaTypes = endpoint.getProduces();
        if (mediaTypes != null && mediaTypes.length != 0) {
            return Arrays.asList(mediaTypes);
        }
        if (this.allSupportedMediaTypes.isEmpty()) {
            return Collections.singletonList(MediaType.ALL);
        }
        ArrayList<MediaType> result = new ArrayList<MediaType>();
        for (HttpMessageConverter<?> converter : this.messageConverters) {
            if (!converter.canWrite(returnValueClass, null)) continue;
            result.addAll(converter.getSupportedMediaTypes());
        }
        return result;
    }

    private MediaType getMostSpecificMediaType(MediaType acceptType, MediaType produceType) {
        return MediaType.SPECIFICITY_COMPARATOR.compare(acceptType, produceType = produceType.copyQualityValue(acceptType)) <= 0 ? acceptType : produceType;
    }

    private MediaType selectMediaType(List<MediaType> mediaTypes) {
        MediaType selectedMediaType = null;
        for (MediaType mediaType : mediaTypes) {
            if (mediaType.isConcrete()) {
                selectedMediaType = mediaType;
                break;
            }
            if (!mediaType.equals((Object)MediaType.ALL) && !mediaType.equals((Object)MEDIA_TYPE_APPLICATION)) continue;
            selectedMediaType = MediaType.APPLICATION_OCTET_STREAM;
            break;
        }
        return selectedMediaType;
    }

    public void setContentNegotiationManager(ContentNegotiationManager contentNegotiationManager) {
        this.contentNegotiationManager = contentNegotiationManager;
    }

    public void setMessageConverters(List<HttpMessageConverter<?>> messageConverters) {
        this.messageConverters = messageConverters;
        LinkedHashSet allSupportedMediaTypes = new LinkedHashSet();
        for (HttpMessageConverter<?> messageConverter : messageConverters) {
            allSupportedMediaTypes.addAll(messageConverter.getSupportedMediaTypes());
        }
        this.allSupportedMediaTypes = new ArrayList<MediaType>(allSupportedMediaTypes);
        MediaType.sortBySpecificity(this.allSupportedMediaTypes);
    }

    private static class WebMvcConfigurationSupportConventions
    extends WebMvcConfigurationSupport {
        private WebMvcConfigurationSupportConventions() {
        }

        public List<HttpMessageConverter<?>> getDefaultHttpMessageConverters() {
            ArrayList converters = new ArrayList();
            this.addDefaultHttpMessageConverters(converters);
            for (HttpMessageConverter httpMessageConverter : converters) {
                if (!(httpMessageConverter instanceof MappingJackson2HttpMessageConverter)) continue;
                MappingJackson2HttpMessageConverter jacksonConverter = (MappingJackson2HttpMessageConverter)httpMessageConverter;
                jacksonConverter.getObjectMapper().disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
            }
            return converters;
        }
    }
}

