/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint;

import java.util.Collection;
import java.util.LinkedHashSet;
import org.springframework.boot.actuate.endpoint.PublicMetrics;
import org.springframework.boot.actuate.metrics.Metric;
import org.springframework.boot.actuate.metrics.MetricRepository;
import org.springframework.util.Assert;

public class VanillaPublicMetrics
implements PublicMetrics {
    private MetricRepository metricRepository;

    public VanillaPublicMetrics(MetricRepository metricRepository) {
        Assert.notNull((Object)metricRepository, (String)"MetricRepository must not be null");
        this.metricRepository = metricRepository;
    }

    @Override
    public Collection<Metric> metrics() {
        LinkedHashSet<Metric> result = new LinkedHashSet<Metric>(this.metricRepository.findAll());
        result.add(new Metric("mem", new Long(Runtime.getRuntime().totalMemory()) / 1024L));
        result.add(new Metric("mem.free", new Long(Runtime.getRuntime().freeMemory()) / 1024L));
        result.add(new Metric("processors", Runtime.getRuntime().availableProcessors()));
        return result;
    }
}

