/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint;

import java.util.Collections;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.endpoint.AbstractEndpoint;
import org.springframework.boot.actuate.endpoint.ActionEndpoint;
import org.springframework.boot.actuate.properties.ManagementServerProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;

@ConfigurationProperties(name="endpoints.shutdown", ignoreUnknownFields=false)
public class ShutdownEndpoint
extends AbstractEndpoint<Map<String, Object>>
implements ApplicationContextAware,
ActionEndpoint<Map<String, Object>> {
    private ConfigurableApplicationContext context;
    @Autowired(required=false)
    private ManagementServerProperties configuration = new ManagementServerProperties();

    public ShutdownEndpoint() {
        super("/shutdown");
    }

    @Override
    public Map<String, Object> invoke() {
        if (this.configuration == null || !this.configuration.isAllowShutdown() || this.context == null) {
            return Collections.singletonMap("message", "Shutdown not enabled, sorry.");
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ShutdownEndpoint.this.context.close();
            }
        }).start();
        return Collections.singletonMap("message", "Shutting down, bye...");
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        if (context instanceof ConfigurableApplicationContext) {
            this.context = (ConfigurableApplicationContext)context;
        }
    }
}

