/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint;

import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.boot.actuate.endpoint.AbstractEndpoint;
import org.springframework.boot.actuate.endpoint.PublicMetrics;
import org.springframework.boot.actuate.metrics.Metric;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.Assert;

@ConfigurationProperties(name="endpoints.metrics", ignoreUnknownFields=false)
public class MetricsEndpoint
extends AbstractEndpoint<Map<String, Object>> {
    private PublicMetrics metrics;

    public MetricsEndpoint(PublicMetrics metrics) {
        super("/metrics");
        Assert.notNull((Object)metrics, (String)"Metrics must not be null");
        this.metrics = metrics;
    }

    @Override
    public Map<String, Object> invoke() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (Metric metric : this.metrics.metrics()) {
            result.put(metric.getName(), metric.getValue());
        }
        return result;
    }
}

