/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure;

import javax.servlet.Servlet;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.actuate.autoconfigure.TraceRepositoryAutoConfiguration;
import org.springframework.boot.actuate.trace.TraceRepository;
import org.springframework.boot.actuate.trace.WebRequestTraceFilter;
import org.springframework.boot.actuate.web.BasicErrorController;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.web.servlet.DispatcherServlet;

@ConditionalOnClass(value={Servlet.class, DispatcherServlet.class})
@AutoConfigureAfter(value={TraceRepositoryAutoConfiguration.class})
public class TraceWebFilterAutoConfiguration {
    @Autowired
    private TraceRepository traceRepository;
    @Autowired(required=false)
    private BasicErrorController errorController;
    @Value(value="${management.dump_requests:false}")
    private boolean dumpRequests;

    @Bean
    public WebRequestTraceFilter webRequestLoggingFilter(BeanFactory beanFactory) {
        WebRequestTraceFilter filter = new WebRequestTraceFilter(this.traceRepository);
        filter.setDumpRequests(this.dumpRequests);
        if (this.errorController != null) {
            filter.setErrorController(this.errorController);
        }
        return filter;
    }
}

