/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.actuate.endpoint.AutoConfigurationReportEndpoint;
import org.springframework.boot.actuate.endpoint.BeansEndpoint;
import org.springframework.boot.actuate.endpoint.DumpEndpoint;
import org.springframework.boot.actuate.endpoint.EnvironmentEndpoint;
import org.springframework.boot.actuate.endpoint.HealthEndpoint;
import org.springframework.boot.actuate.endpoint.InfoEndpoint;
import org.springframework.boot.actuate.endpoint.MetricsEndpoint;
import org.springframework.boot.actuate.endpoint.PublicMetrics;
import org.springframework.boot.actuate.endpoint.ShutdownEndpoint;
import org.springframework.boot.actuate.endpoint.TraceEndpoint;
import org.springframework.boot.actuate.endpoint.VanillaPublicMetrics;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.actuate.health.VanillaHealthIndicator;
import org.springframework.boot.actuate.metrics.InMemoryMetricRepository;
import org.springframework.boot.actuate.metrics.MetricRepository;
import org.springframework.boot.actuate.trace.InMemoryTraceRepository;
import org.springframework.boot.actuate.trace.TraceRepository;
import org.springframework.boot.autoconfigure.AutoConfigurationReport;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.bind.PropertiesConfigurationFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertySources;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.http.MediaType;

@Configuration
@ConditionalOnClass(value={MediaType.class})
public class EndpointAutoConfiguration {
    @Autowired(required=false)
    private HealthIndicator<? extends Object> healthIndicator = new VanillaHealthIndicator();
    @Autowired
    private InfoPropertiesConfiguration properties;
    @Autowired(required=false)
    private MetricRepository metricRepository = new InMemoryMetricRepository();
    @Autowired(required=false)
    private PublicMetrics metrics;
    @Autowired(required=false)
    private TraceRepository traceRepository = new InMemoryTraceRepository();

    @Bean
    @ConditionalOnMissingBean
    public EnvironmentEndpoint environmentEndpoint() {
        return new EnvironmentEndpoint();
    }

    @Bean
    @ConditionalOnMissingBean
    public HealthEndpoint<Object> healthEndpoint() {
        return new HealthEndpoint<Object>(this.healthIndicator);
    }

    @Bean
    @ConditionalOnMissingBean
    public BeansEndpoint beansEndpoint() {
        return new BeansEndpoint();
    }

    @Bean
    @ConditionalOnMissingBean
    public InfoEndpoint infoEndpoint() throws Exception {
        LinkedHashMap<String, Object> info = new LinkedHashMap<String, Object>();
        info.putAll(this.properties.infoMap());
        GitInfo gitInfo = this.properties.gitInfo();
        if (gitInfo.getBranch() != null) {
            info.put("git", gitInfo);
        }
        return new InfoEndpoint(info);
    }

    @Bean
    @ConditionalOnMissingBean
    public MetricsEndpoint metricsEndpoint() {
        if (this.metrics == null) {
            this.metrics = new VanillaPublicMetrics(this.metricRepository);
        }
        return new MetricsEndpoint(this.metrics);
    }

    @Bean
    @ConditionalOnMissingBean
    public TraceEndpoint traceEndpoint() {
        return new TraceEndpoint(this.traceRepository);
    }

    @Bean
    @ConditionalOnMissingBean
    public DumpEndpoint dumpEndpoint() {
        return new DumpEndpoint();
    }

    @Bean
    @ConditionalOnBean(value={AutoConfigurationReport.class})
    @ConditionalOnMissingBean
    public AutoConfigurationReportEndpoint autoConfigurationAuditEndpoint() {
        return new AutoConfigurationReportEndpoint();
    }

    @Bean
    @ConditionalOnMissingBean
    public ShutdownEndpoint shutdownEndpoint() {
        return new ShutdownEndpoint();
    }

    public static class GitInfo {
        private String branch;
        private Commit commit = new Commit();

        public String getBranch() {
            return this.branch;
        }

        public void setBranch(String branch) {
            this.branch = branch;
        }

        public Commit getCommit() {
            return this.commit;
        }

        public static class Commit {
            private String id;
            private String time;

            public String getId() {
                return this.id == null ? "" : (this.id.length() > 7 ? this.id.substring(0, 7) : this.id);
            }

            public void setId(String id) {
                this.id = id;
            }

            public String getTime() {
                return this.time;
            }

            public void setTime(String time) {
                this.time = time;
            }
        }
    }

    @Configuration
    protected static class InfoPropertiesConfiguration {
        @Autowired
        private ConfigurableEnvironment environment = new StandardEnvironment();
        @Value(value="${spring.git.properties:classpath:git.properties}")
        private Resource gitProperties;

        protected InfoPropertiesConfiguration() {
        }

        public GitInfo gitInfo() throws Exception {
            PropertiesConfigurationFactory factory = new PropertiesConfigurationFactory((Object)new GitInfo());
            factory.setTargetName("git");
            Properties properties = new Properties();
            if (this.gitProperties.exists()) {
                properties = PropertiesLoaderUtils.loadProperties((Resource)this.gitProperties);
            }
            factory.setProperties(properties);
            return (GitInfo)factory.getObject();
        }

        public Map<String, Object> infoMap() throws Exception {
            PropertiesConfigurationFactory factory = new PropertiesConfigurationFactory(new LinkedHashMap());
            factory.setTargetName("info");
            factory.setPropertySources((PropertySources)this.environment.getPropertySources());
            return (Map)factory.getObject();
        }
    }
}

