/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.web.server;

import java.net.InetAddress;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.boot.web.server.Ssl;
import org.springframework.lang.Contract;
import org.springframework.util.StringUtils;

@ConfigurationProperties(value="management.server")
public class ManagementServerProperties {
    private @Nullable Integer port;
    private @Nullable InetAddress address;
    private String basePath = "";
    @NestedConfigurationProperty
    private @Nullable Ssl ssl;

    public @Nullable Integer getPort() {
        return this.port;
    }

    public void setPort(@Nullable Integer port) {
        this.port = port;
    }

    public @Nullable InetAddress getAddress() {
        return this.address;
    }

    public void setAddress(@Nullable InetAddress address) {
        this.address = address;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = this.cleanBasePath(basePath);
    }

    public @Nullable Ssl getSsl() {
        return this.ssl;
    }

    public void setSsl(@Nullable Ssl ssl) {
        this.ssl = ssl;
    }

    @Contract(value="!null -> !null")
    private @Nullable String cleanBasePath(@Nullable String basePath) {
        if (basePath == null) {
            return null;
        }
        Object candidate = basePath.strip();
        if (StringUtils.hasText((String)candidate)) {
            if (!((String)candidate).startsWith("/")) {
                candidate = "/" + (String)candidate;
            }
            if (((String)candidate).endsWith("/")) {
                candidate = ((String)candidate).substring(0, ((String)candidate).length() - 1);
            }
        }
        return candidate;
    }
}

