/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.startup;

import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.actuate.startup.StartupEndpoint;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.context.metrics.buffering.BufferingApplicationStartup;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.core.metrics.ApplicationStartup;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.Assert;

@AutoConfiguration
@ConditionalOnAvailableEndpoint(value=StartupEndpoint.class)
@Conditional(value={ApplicationStartupCondition.class})
public final class StartupEndpointAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    StartupEndpoint startupEndpoint(BufferingApplicationStartup applicationStartup) {
        return new StartupEndpoint(applicationStartup);
    }

    static class ApplicationStartupCondition
    extends SpringBootCondition {
        ApplicationStartupCondition() {
        }

        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            ConditionMessage.Builder message = ConditionMessage.forCondition((String)"ApplicationStartup", (Object[])new Object[0]);
            ConfigurableListableBeanFactory beanFactory = context.getBeanFactory();
            Assert.state((beanFactory != null ? 1 : 0) != 0, (String)"'beanFactory' must not be null");
            ApplicationStartup applicationStartup = beanFactory.getApplicationStartup();
            if (applicationStartup instanceof BufferingApplicationStartup) {
                return ConditionOutcome.match((ConditionMessage)message.because("configured applicationStartup is of type BufferingApplicationStartup."));
            }
            return ConditionOutcome.noMatch((ConditionMessage)message.because("configured applicationStartup is of type " + String.valueOf(applicationStartup.getClass()) + ", expected BufferingApplicationStartup."));
        }
    }
}

