/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.health;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.springframework.lang.Contract;

class IncludeExcludeGroupMemberPredicate
implements Predicate<String> {
    private final Set<String> include;
    private final Set<String> exclude;

    IncludeExcludeGroupMemberPredicate(@Nullable Set<String> include, @Nullable Set<String> exclude) {
        this.include = this.clean(include);
        this.exclude = this.clean(exclude);
    }

    @Override
    public boolean test(String name) {
        return this.isIncluded(name = this.clean(name)) && !this.isExcluded(name);
    }

    private boolean isIncluded(String name) {
        return this.include.isEmpty() || this.include.contains("*") || this.isIncludedName(name);
    }

    private boolean isIncludedName(String name) {
        if (this.include.contains(name)) {
            return true;
        }
        if (name.contains("/")) {
            String parent = name.substring(0, name.lastIndexOf("/"));
            return this.isIncludedName(parent);
        }
        return false;
    }

    private boolean isExcluded(String name) {
        return this.exclude.contains("*") || this.isExcludedName(name);
    }

    private boolean isExcludedName(String name) {
        if (this.exclude.contains(name)) {
            return true;
        }
        if (name.contains("/")) {
            String parent = name.substring(0, name.lastIndexOf("/"));
            return this.isExcludedName(parent);
        }
        return false;
    }

    private Set<String> clean(@Nullable Set<String> names) {
        if (names == null) {
            return Collections.emptySet();
        }
        Set cleaned = names.stream().map(this::clean).collect(Collectors.toCollection(LinkedHashSet::new));
        return Collections.unmodifiableSet(cleaned);
    }

    @Contract(value="!null -> !null")
    private @Nullable String clean(@Nullable String name) {
        return name != null ? name.trim() : null;
    }
}

