/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.web.server;

import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.boot.actuate.autoconfigure.web.ManagementContextType;
import org.springframework.boot.actuate.autoconfigure.web.server.ChildManagementContextInitializer;
import org.springframework.boot.actuate.autoconfigure.web.server.ConditionalOnManagementPort;
import org.springframework.boot.actuate.autoconfigure.web.server.EnableManagementContext;
import org.springframework.boot.actuate.autoconfigure.web.server.ManagementContextFactory;
import org.springframework.boot.actuate.autoconfigure.web.server.ManagementPortType;
import org.springframework.boot.actuate.autoconfigure.web.server.ManagementServerProperties;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.origin.Origin;
import org.springframework.boot.origin.OriginLookup;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;
import org.springframework.util.Assert;

@AutoConfiguration
@AutoConfigureOrder(value=0x7FFFFFFF)
public final class ManagementContextAutoConfiguration {

    static class LocalManagementPortPropertySource
    extends EnumerablePropertySource<Object>
    implements OriginLookup<String> {
        private static final Map<String, String> PROPERTY_MAPPINGS = Map.of("local.management.port", "local.server.port");
        private static final String[] PROPERTY_NAMES = (String[])PROPERTY_MAPPINGS.keySet().toArray(String[]::new);
        private final Environment environment;

        LocalManagementPortPropertySource(Environment environment) {
            super("Management Server");
            this.environment = environment;
        }

        public String[] getPropertyNames() {
            return PROPERTY_NAMES;
        }

        public @Nullable Object getProperty(String name) {
            String mapped = PROPERTY_MAPPINGS.get(name);
            return mapped != null ? this.environment.getProperty(mapped) : null;
        }

        public @Nullable Origin getOrigin(String key) {
            return null;
        }

        public boolean isImmutable() {
            return true;
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnManagementPort(value=ManagementPortType.DIFFERENT)
    @EnableConfigurationProperties(value={ManagementServerProperties.class})
    static class DifferentManagementContextConfiguration {
        DifferentManagementContextConfiguration() {
        }

        @Bean
        static ChildManagementContextInitializer childManagementContextInitializer(ManagementContextFactory managementContextFactory, AbstractApplicationContext parentContext) {
            return new ChildManagementContextInitializer(managementContextFactory, parentContext);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnManagementPort(value=ManagementPortType.SAME)
    static class SameManagementContextConfiguration
    implements SmartInitializingSingleton {
        private final Environment environment;

        SameManagementContextConfiguration(Environment environment) {
            this.environment = environment;
        }

        public void afterSingletonsInstantiated() {
            this.verifySslConfiguration();
            this.verifyAddressConfiguration();
            Environment environment = this.environment;
            if (environment instanceof ConfigurableEnvironment) {
                ConfigurableEnvironment configurableEnvironment = (ConfigurableEnvironment)environment;
                this.addLocalManagementPortPropertyAlias(configurableEnvironment);
            }
        }

        private void verifySslConfiguration() {
            Boolean enabled = (Boolean)this.environment.getProperty("management.server.ssl.enabled", Boolean.class, (Object)false);
            Assert.state((enabled == false ? 1 : 0) != 0, (String)"Management-specific SSL cannot be configured as the management server is not listening on a separate port");
        }

        private void verifyAddressConfiguration() {
            String address = this.environment.getProperty("management.server.address");
            Assert.state((address == null ? 1 : 0) != 0, (String)"Management-specific server address cannot be configured as the management server is not listening on a separate port");
        }

        private void addLocalManagementPortPropertyAlias(ConfigurableEnvironment environment) {
            environment.getPropertySources().addLast((PropertySource)new LocalManagementPortPropertySource((Environment)environment));
        }

        @Configuration(proxyBeanMethods=false)
        @EnableManagementContext(value=ManagementContextType.SAME)
        static class EnableSameManagementContextConfiguration {
            EnableSameManagementContextConfiguration() {
            }
        }
    }
}

