/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.sbom;

import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.actuate.autoconfigure.endpoint.expose.EndpointExposure;
import org.springframework.boot.actuate.sbom.SbomEndpoint;
import org.springframework.boot.actuate.sbom.SbomEndpointWebExtension;
import org.springframework.boot.actuate.sbom.SbomProperties;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.core.io.ResourceLoader;

@AutoConfiguration
@ConditionalOnAvailableEndpoint(value=SbomEndpoint.class)
@EnableConfigurationProperties(value={SbomProperties.class})
public final class SbomEndpointAutoConfiguration {
    private final SbomProperties properties;

    SbomEndpointAutoConfiguration(SbomProperties properties) {
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean
    SbomEndpoint sbomEndpoint(ResourceLoader resourceLoader) {
        return new SbomEndpoint(this.properties, resourceLoader);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={SbomEndpoint.class})
    @ConditionalOnAvailableEndpoint(exposure={EndpointExposure.WEB})
    SbomEndpointWebExtension sbomEndpointWebExtension(SbomEndpoint sbomEndpoint) {
        return new SbomEndpointWebExtension(sbomEndpoint, this.properties);
    }
}

