/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.audit;

import org.springframework.boot.actuate.audit.AuditEventRepository;
import org.springframework.boot.actuate.audit.listener.AbstractAuditListener;
import org.springframework.boot.actuate.audit.listener.AuditListener;
import org.springframework.boot.actuate.security.AbstractAuthenticationAuditListener;
import org.springframework.boot.actuate.security.AbstractAuthorizationAuditListener;
import org.springframework.boot.actuate.security.AuthenticationAuditListener;
import org.springframework.boot.actuate.security.AuthorizationAuditListener;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBooleanProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConditionalOnBean(value={AuditEventRepository.class})
@ConditionalOnBooleanProperty(name={"management.auditevents.enabled"}, matchIfMissing=true)
public final class AuditAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={AbstractAuditListener.class})
    AuditListener auditListener(AuditEventRepository auditEventRepository) {
        return new AuditListener(auditEventRepository);
    }

    @Bean
    @ConditionalOnClass(name={"org.springframework.security.authentication.event.AbstractAuthenticationEvent"})
    @ConditionalOnMissingBean(value={AbstractAuthenticationAuditListener.class})
    AuthenticationAuditListener authenticationAuditListener() {
        return new AuthenticationAuditListener();
    }

    @Bean
    @ConditionalOnClass(name={"org.springframework.security.access.event.AbstractAuthorizationEvent"})
    @ConditionalOnMissingBean(value={AbstractAuthorizationAuditListener.class})
    AuthorizationAuditListener authorizationAuditListener() {
        return new AuthorizationAuditListener();
    }
}

