/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.condition;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.actuate.endpoint.OperationResponseBody;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.autoconfigure.condition.ConditionEvaluationReport;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Condition;
import org.springframework.util.ClassUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

@Endpoint(id="conditions")
public class ConditionsReportEndpoint {
    private final ConfigurableApplicationContext context;

    public ConditionsReportEndpoint(ConfigurableApplicationContext context) {
        this.context = context;
    }

    @ReadOperation
    public ConditionsDescriptor conditions() {
        HashMap<String, ContextConditionsDescriptor> contextConditionEvaluations = new HashMap<String, ContextConditionsDescriptor>();
        ConfigurableApplicationContext target = this.context;
        while (target != null) {
            contextConditionEvaluations.put(target.getId(), new ContextConditionsDescriptor(target));
            target = this.getConfigurableParent(target);
        }
        return new ConditionsDescriptor(contextConditionEvaluations);
    }

    private ConfigurableApplicationContext getConfigurableParent(ConfigurableApplicationContext context) {
        ApplicationContext parent = context.getParent();
        if (parent instanceof ConfigurableApplicationContext) {
            ConfigurableApplicationContext configurableParent = (ConfigurableApplicationContext)parent;
            return configurableParent;
        }
        return null;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public static final class ContextConditionsDescriptor {
        private final MultiValueMap<String, MessageAndConditionDescriptor> positiveMatches;
        private final Map<String, MessageAndConditionsDescriptor> negativeMatches;
        private final List<String> exclusions;
        private final Set<String> unconditionalClasses;
        private final String parentId;

        public ContextConditionsDescriptor(ConfigurableApplicationContext context) {
            ConditionEvaluationReport report = ConditionEvaluationReport.get((ConfigurableListableBeanFactory)context.getBeanFactory());
            this.positiveMatches = new LinkedMultiValueMap();
            this.negativeMatches = new LinkedHashMap<String, MessageAndConditionsDescriptor>();
            this.exclusions = report.getExclusions();
            this.unconditionalClasses = report.getUnconditionalClasses();
            report.getConditionAndOutcomesBySource().forEach(this::add);
            this.parentId = context.getParent() != null ? context.getParent().getId() : null;
        }

        private void add(String source, ConditionEvaluationReport.ConditionAndOutcomes conditionAndOutcomes) {
            String name = ClassUtils.getShortName((String)source);
            if (conditionAndOutcomes.isFullMatch()) {
                conditionAndOutcomes.forEach(conditionAndOutcome -> this.positiveMatches.add((Object)name, (Object)new MessageAndConditionDescriptor((ConditionEvaluationReport.ConditionAndOutcome)conditionAndOutcome)));
            } else {
                this.negativeMatches.put(name, new MessageAndConditionsDescriptor(conditionAndOutcomes));
            }
        }

        public Map<String, List<MessageAndConditionDescriptor>> getPositiveMatches() {
            return this.positiveMatches;
        }

        public Map<String, MessageAndConditionsDescriptor> getNegativeMatches() {
            return this.negativeMatches;
        }

        public List<String> getExclusions() {
            return this.exclusions;
        }

        public Set<String> getUnconditionalClasses() {
            return this.unconditionalClasses;
        }

        public String getParentId() {
            return this.parentId;
        }
    }

    public static final class ConditionsDescriptor
    implements OperationResponseBody {
        private final Map<String, ContextConditionsDescriptor> contexts;

        private ConditionsDescriptor(Map<String, ContextConditionsDescriptor> contexts) {
            this.contexts = contexts;
        }

        public Map<String, ContextConditionsDescriptor> getContexts() {
            return this.contexts;
        }
    }

    @JsonPropertyOrder(value={"condition", "message"})
    public static class MessageAndConditionDescriptor {
        private final String condition;
        private final String message;

        public MessageAndConditionDescriptor(ConditionEvaluationReport.ConditionAndOutcome conditionAndOutcome) {
            Condition condition = conditionAndOutcome.getCondition();
            ConditionOutcome outcome = conditionAndOutcome.getOutcome();
            this.condition = ClassUtils.getShortName((Class)condition.getClass());
            this.message = StringUtils.hasLength((String)outcome.getMessage()) ? outcome.getMessage() : (outcome.isMatch() ? "matched" : "did not match");
        }

        public String getCondition() {
            return this.condition;
        }

        public String getMessage() {
            return this.message;
        }
    }

    @JsonPropertyOrder(value={"notMatched", "matched"})
    public static class MessageAndConditionsDescriptor {
        private final List<MessageAndConditionDescriptor> notMatched = new ArrayList<MessageAndConditionDescriptor>();
        private final List<MessageAndConditionDescriptor> matched = new ArrayList<MessageAndConditionDescriptor>();

        public MessageAndConditionsDescriptor(ConditionEvaluationReport.ConditionAndOutcomes conditionAndOutcomes) {
            for (ConditionEvaluationReport.ConditionAndOutcome conditionAndOutcome : conditionAndOutcomes) {
                List<MessageAndConditionDescriptor> target = conditionAndOutcome.getOutcome().isMatch() ? this.matched : this.notMatched;
                target.add(new MessageAndConditionDescriptor(conditionAndOutcome));
            }
        }

        public List<MessageAndConditionDescriptor> getNotMatched() {
            return this.notMatched;
        }

        public List<MessageAndConditionDescriptor> getMatched() {
            return this.matched;
        }
    }
}

