/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.metrics;

import io.micrometer.core.aop.CountedAspect;
import io.micrometer.core.aop.MeterTagAnnotationHandler;
import io.micrometer.core.aop.TimedAspect;
import io.micrometer.core.instrument.MeterRegistry;
import org.aspectj.weaver.Advice;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.autoconfigure.metrics.CompositeMeterRegistryAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.MetricsAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBooleanProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(after={MetricsAutoConfiguration.class, CompositeMeterRegistryAutoConfiguration.class})
@ConditionalOnClass(value={MeterRegistry.class, Advice.class})
@ConditionalOnBooleanProperty(value={"management.observations.annotations.enabled"})
@ConditionalOnBean(value={MeterRegistry.class})
public class MetricsAspectsAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    CountedAspect countedAspect(MeterRegistry registry) {
        return new CountedAspect(registry);
    }

    @Bean
    @ConditionalOnMissingBean
    TimedAspect timedAspect(MeterRegistry registry, ObjectProvider<MeterTagAnnotationHandler> meterTagAnnotationHandler) {
        TimedAspect timedAspect = new TimedAspect(registry);
        meterTagAnnotationHandler.ifAvailable(arg_0 -> ((TimedAspect)timedAspect).setMeterTagAnnotationHandler(arg_0));
        return timedAspect;
    }
}

