/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.web.exchanges;

import org.springframework.boot.actuate.autoconfigure.web.exchanges.HttpExchangesProperties;
import org.springframework.boot.actuate.web.exchanges.HttpExchangeRepository;
import org.springframework.boot.actuate.web.exchanges.reactive.HttpExchangesWebFilter;
import org.springframework.boot.actuate.web.exchanges.servlet.HttpExchangesFilter;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBooleanProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@AutoConfiguration
@ConditionalOnWebApplication
@ConditionalOnBooleanProperty(name={"management.httpexchanges.recording.enabled"}, matchIfMissing=true)
@ConditionalOnBean(value={HttpExchangeRepository.class})
@EnableConfigurationProperties(value={HttpExchangesProperties.class})
public class HttpExchangesAutoConfiguration {

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
    static class ReactiveHttpExchangesConfiguration {
        ReactiveHttpExchangesConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        HttpExchangesWebFilter httpExchangesWebFilter(HttpExchangeRepository repository, HttpExchangesProperties properties) {
            return new HttpExchangesWebFilter(repository, properties.getRecording().getInclude());
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    static class ServletHttpExchangesConfiguration {
        ServletHttpExchangesConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        HttpExchangesFilter httpExchangesFilter(HttpExchangeRepository repository, HttpExchangesProperties properties) {
            return new HttpExchangesFilter(repository, properties.getRecording().getInclude());
        }
    }
}

