/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.tracing.zipkin;

import brave.Tag;
import brave.Tags;
import brave.handler.MutableSpan;
import io.opentelemetry.exporter.zipkin.ZipkinSpanExporter;
import java.net.http.HttpClient;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.autoconfigure.tracing.ConditionalOnEnabledTracing;
import org.springframework.boot.actuate.autoconfigure.tracing.zipkin.PropertiesZipkinConnectionDetails;
import org.springframework.boot.actuate.autoconfigure.tracing.zipkin.ZipkinConnectionDetails;
import org.springframework.boot.actuate.autoconfigure.tracing.zipkin.ZipkinHttpClientBuilderCustomizer;
import org.springframework.boot.actuate.autoconfigure.tracing.zipkin.ZipkinHttpClientSender;
import org.springframework.boot.actuate.autoconfigure.tracing.zipkin.ZipkinProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import zipkin2.Span;
import zipkin2.reporter.BytesEncoder;
import zipkin2.reporter.BytesMessageSender;
import zipkin2.reporter.Encoding;
import zipkin2.reporter.HttpEndpointSupplier;
import zipkin2.reporter.HttpEndpointSuppliers;
import zipkin2.reporter.SpanBytesEncoder;
import zipkin2.reporter.brave.AsyncZipkinSpanHandler;
import zipkin2.reporter.brave.MutableSpanBytesEncoder;

class ZipkinConfigurations {
    ZipkinConfigurations() {
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={ZipkinSpanExporter.class, Span.class})
    static class OpenTelemetryConfiguration {
        OpenTelemetryConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={Span.class}, parameterizedContainer={BytesEncoder.class})
        BytesEncoder<Span> spanBytesEncoder(Encoding encoding) {
            return SpanBytesEncoder.forEncoding((Encoding)encoding);
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnBean(value={BytesMessageSender.class})
        @ConditionalOnEnabledTracing(value="zipkin")
        ZipkinSpanExporter zipkinSpanExporter(BytesMessageSender sender, BytesEncoder<Span> spanBytesEncoder) {
            return ZipkinSpanExporter.builder().setSender(sender).setEncoder(spanBytesEncoder).build();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={AsyncZipkinSpanHandler.class})
    static class BraveConfiguration {
        BraveConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={MutableSpan.class}, parameterizedContainer={BytesEncoder.class})
        BytesEncoder<MutableSpan> mutableSpanBytesEncoder(Encoding encoding, ObjectProvider<Tag<Throwable>> throwableTagProvider) {
            Tag throwableTag = (Tag)throwableTagProvider.getIfAvailable(() -> Tags.ERROR);
            return MutableSpanBytesEncoder.create((Encoding)encoding, (Tag)throwableTag);
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnBean(value={BytesMessageSender.class})
        @ConditionalOnEnabledTracing(value="zipkin")
        AsyncZipkinSpanHandler asyncZipkinSpanHandler(BytesMessageSender sender, BytesEncoder<MutableSpan> mutableSpanBytesEncoder) {
            return AsyncZipkinSpanHandler.newBuilder((BytesMessageSender)sender).build(mutableSpanBytesEncoder);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={HttpClient.class})
    @EnableConfigurationProperties(value={ZipkinProperties.class})
    static class HttpClientSenderConfiguration {
        HttpClientSenderConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={BytesMessageSender.class})
        ZipkinHttpClientSender httpClientSender(ZipkinProperties properties, Encoding encoding, ObjectProvider<ZipkinHttpClientBuilderCustomizer> customizers, ObjectProvider<ZipkinConnectionDetails> connectionDetailsProvider, ObjectProvider<HttpEndpointSupplier.Factory> endpointSupplierFactoryProvider) {
            ZipkinConnectionDetails connectionDetails = (ZipkinConnectionDetails)connectionDetailsProvider.getIfAvailable(() -> new PropertiesZipkinConnectionDetails(properties));
            HttpEndpointSupplier.Factory endpointSupplierFactory = (HttpEndpointSupplier.Factory)endpointSupplierFactoryProvider.getIfAvailable(HttpEndpointSuppliers::constantFactory);
            HttpClient.Builder httpClientBuilder = HttpClient.newBuilder().connectTimeout(properties.getConnectTimeout());
            customizers.orderedStream().forEach(customizer -> customizer.customize(httpClientBuilder));
            return new ZipkinHttpClientSender(encoding, endpointSupplierFactory, connectionDetails.getSpanEndpoint(), httpClientBuilder.build(), properties.getReadTimeout());
        }
    }

    @Configuration(proxyBeanMethods=false)
    @Import(value={HttpClientSenderConfiguration.class})
    static class SenderConfiguration {
        SenderConfiguration() {
        }
    }
}

