/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.ssl;

import io.micrometer.core.instrument.MeterRegistry;
import org.springframework.boot.actuate.autoconfigure.metrics.CompositeMeterRegistryAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.MetricsAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.ssl.SslHealthIndicatorProperties;
import org.springframework.boot.actuate.autoconfigure.ssl.SslMeterBinder;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.ssl.SslAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.info.SslInfo;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(after={MetricsAutoConfiguration.class, CompositeMeterRegistryAutoConfiguration.class, SslAutoConfiguration.class})
@ConditionalOnClass(value={MeterRegistry.class})
@ConditionalOnBean(value={MeterRegistry.class, SslBundles.class})
@EnableConfigurationProperties(value={SslHealthIndicatorProperties.class})
public class SslObservabilityAutoConfiguration {
    @Bean
    SslMeterBinder sslMeterBinder(SslInfo sslInfo, SslBundles sslBundles) {
        return new SslMeterBinder(sslInfo, sslBundles);
    }

    @Bean
    @ConditionalOnMissingBean
    SslInfo sslInfoProvider(SslBundles sslBundles, SslHealthIndicatorProperties properties) {
        return new SslInfo(sslBundles, properties.getCertificateValidityWarningThreshold());
    }
}

