/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.endpoint.jackson;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import org.springframework.boot.actuate.endpoint.jackson.EndpointObjectMapper;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBooleanProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;

@AutoConfiguration(after={JacksonAutoConfiguration.class})
@ConditionalOnClass(value={ObjectMapper.class, Jackson2ObjectMapperBuilder.class})
public class JacksonEndpointAutoConfiguration {
    @Bean
    @ConditionalOnBooleanProperty(name={"management.endpoints.jackson.isolated-object-mapper"}, matchIfMissing=true)
    public EndpointObjectMapper endpointObjectMapper() {
        ObjectMapper objectMapper = Jackson2ObjectMapperBuilder.json().featuresToDisable(new Object[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, SerializationFeature.WRITE_DURATIONS_AS_TIMESTAMPS}).serializationInclusion(JsonInclude.Include.NON_NULL).build();
        return () -> objectMapper;
    }
}

