/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.tracing.otlp;

import io.opentelemetry.exporter.otlp.http.trace.OtlpHttpSpanExporter;
import io.opentelemetry.exporter.otlp.http.trace.OtlpHttpSpanExporterBuilder;
import io.opentelemetry.exporter.otlp.trace.OtlpGrpcSpanExporter;
import io.opentelemetry.exporter.otlp.trace.OtlpGrpcSpanExporterBuilder;
import java.util.Map;
import org.springframework.boot.actuate.autoconfigure.opentelemetry.otlp.Transport;
import org.springframework.boot.actuate.autoconfigure.tracing.ConditionalOnEnabledTracing;
import org.springframework.boot.actuate.autoconfigure.tracing.otlp.OtlpProperties;
import org.springframework.boot.actuate.autoconfigure.tracing.otlp.OtlpTracingConnectionDetails;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.Assert;

class OtlpTracingConfigurations {
    OtlpTracingConfigurations() {
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingBean(value={OtlpGrpcSpanExporter.class, OtlpHttpSpanExporter.class})
    @ConditionalOnBean(value={OtlpTracingConnectionDetails.class})
    @ConditionalOnEnabledTracing(value="otlp")
    static class Exporters {
        Exporters() {
        }

        @Bean
        @ConditionalOnProperty(prefix="management.otlp.tracing", name={"transport"}, havingValue="http", matchIfMissing=true)
        OtlpHttpSpanExporter otlpHttpSpanExporter(OtlpProperties properties, OtlpTracingConnectionDetails connectionDetails) {
            OtlpHttpSpanExporterBuilder builder = OtlpHttpSpanExporter.builder().setEndpoint(connectionDetails.getUrl(Transport.HTTP)).setTimeout(properties.getTimeout()).setCompression(properties.getCompression().name().toLowerCase());
            for (Map.Entry<String, String> header : properties.getHeaders().entrySet()) {
                builder.addHeader(header.getKey(), header.getValue());
            }
            return builder.build();
        }

        @Bean
        @ConditionalOnProperty(prefix="management.otlp.tracing", name={"transport"}, havingValue="grpc")
        OtlpGrpcSpanExporter otlpGrpcSpanExporter(OtlpProperties properties, OtlpTracingConnectionDetails connectionDetails) {
            OtlpGrpcSpanExporterBuilder builder = OtlpGrpcSpanExporter.builder().setEndpoint(connectionDetails.getUrl(Transport.GRPC)).setTimeout(properties.getTimeout()).setCompression(properties.getCompression().name().toLowerCase());
            for (Map.Entry<String, String> header : properties.getHeaders().entrySet()) {
                builder.addHeader(header.getKey(), header.getValue());
            }
            return builder.build();
        }
    }

    @Configuration(proxyBeanMethods=false)
    static class ConnectionDetails {
        ConnectionDetails() {
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnProperty(prefix="management.otlp.tracing", name={"endpoint"})
        OtlpTracingConnectionDetails otlpTracingConnectionDetails(OtlpProperties properties) {
            return new PropertiesOtlpTracingConnectionDetails(properties);
        }

        static class PropertiesOtlpTracingConnectionDetails
        implements OtlpTracingConnectionDetails {
            private final OtlpProperties properties;

            PropertiesOtlpTracingConnectionDetails(OtlpProperties properties) {
                this.properties = properties;
            }

            @Override
            public String getUrl(Transport transport) {
                Assert.state((transport == this.properties.getTransport() ? 1 : 0) != 0, (String)"Requested transport %s doesn't match configured transport %s".formatted(new Object[]{transport, this.properties.getTransport()}));
                return this.properties.getEndpoint();
            }
        }
    }
}

