/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.tracing;

import io.micrometer.tracing.otel.bridge.EventPublishingContextWrapper;
import io.micrometer.tracing.otel.bridge.OtelTracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ContextStorage;
import io.opentelemetry.context.Scope;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.boot.context.event.ApplicationStartingEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.GenericApplicationListener;
import org.springframework.core.ResolvableType;
import org.springframework.util.ClassUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class OpenTelemetryEventPublisherBeansApplicationListener
implements GenericApplicationListener {
    private static final boolean OTEL_CONTEXT_PRESENT = ClassUtils.isPresent((String)"io.opentelemetry.context.ContextStorage", null);
    private static final boolean MICROMETER_OTEL_PRESENT = ClassUtils.isPresent((String)"io.micrometer.tracing.otel.bridge.OtelTracer", null);
    private static final AtomicBoolean added = new AtomicBoolean();

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    public boolean supportsEventType(ResolvableType eventType) {
        Class type = eventType.getRawClass();
        return type != null && (ApplicationStartingEvent.class.isAssignableFrom(type) || ContextRefreshedEvent.class.isAssignableFrom(type) || ContextClosedEvent.class.isAssignableFrom(type));
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (!OpenTelemetryEventPublisherBeansApplicationListener.isInstallable()) {
            return;
        }
        if (event instanceof ApplicationStartingEvent) {
            OpenTelemetryEventPublisherBeansApplicationListener.addWrapper();
        }
        if (event instanceof ContextRefreshedEvent) {
            ContextRefreshedEvent contextRefreshedEvent = (ContextRefreshedEvent)event;
            ApplicationContext applicationContext = contextRefreshedEvent.getApplicationContext();
            List<EventPublishingContextWrapper> publishers = applicationContext.getBeansOfType(OtelTracer.EventPublisher.class, true, false).values().stream().map(EventPublishingContextWrapper::new).toList();
            Wrapper.instance.put(applicationContext, publishers);
        }
        if (event instanceof ContextClosedEvent) {
            ContextClosedEvent contextClosedEvent = (ContextClosedEvent)event;
            Wrapper.instance.remove(contextClosedEvent.getApplicationContext());
        }
    }

    public static void addWrapper() {
        if (OpenTelemetryEventPublisherBeansApplicationListener.isInstallable() && added.compareAndSet(false, true)) {
            Wrapper.instance.addWrapper();
        }
    }

    private static boolean isInstallable() {
        return OTEL_CONTEXT_PRESENT && MICROMETER_OTEL_PRESENT;
    }

    static final class Wrapper {
        static Wrapper instance = new Wrapper();
        private final MultiValueMap<ApplicationContext, EventPublishingContextWrapper> beans = new LinkedMultiValueMap();
        private volatile ContextStorage storageDelegate;

        private Wrapper() {
        }

        private void addWrapper() {
            ContextStorage.addWrapper(x$0 -> new Storage((ContextStorage)x$0));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void put(ApplicationContext applicationContext, List<EventPublishingContextWrapper> publishers) {
            Wrapper wrapper = this;
            synchronized (wrapper) {
                this.beans.addAll((Object)applicationContext, publishers);
                this.storageDelegate = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void remove(ApplicationContext applicationContext) {
            Wrapper wrapper = this;
            synchronized (wrapper) {
                this.beans.remove((Object)applicationContext);
                this.storageDelegate = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ContextStorage getStorageDelegate(ContextStorage parent) {
            ContextStorage delegate = this.storageDelegate;
            if (delegate == null) {
                Wrapper wrapper = this;
                synchronized (wrapper) {
                    delegate = parent;
                    for (List publishers : this.beans.values()) {
                        for (EventPublishingContextWrapper publisher : publishers) {
                            delegate = publisher.apply(delegate);
                        }
                    }
                    this.storageDelegate = delegate;
                }
            }
            return delegate;
        }

        class Storage
        implements ContextStorage {
            private final ContextStorage parent;

            Storage(ContextStorage parent) {
                this.parent = parent;
            }

            public Scope attach(Context toAttach) {
                return this.getDelegate().attach(toAttach);
            }

            public Context current() {
                return this.getDelegate().current();
            }

            public Context root() {
                return this.getDelegate().root();
            }

            private ContextStorage getDelegate() {
                return Wrapper.this.getStorageDelegate(this.parent);
            }
        }
    }
}

