/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.metrics.export.otlp;

import io.micrometer.registry.otlp.AggregationTemporality;
import io.micrometer.registry.otlp.HistogramFlavor;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.springframework.boot.actuate.autoconfigure.metrics.export.properties.StepRegistryProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.DeprecatedConfigurationProperty;

@ConfigurationProperties(prefix="management.otlp.metrics.export")
public class OtlpProperties
extends StepRegistryProperties {
    private String url = "http://localhost:4318/v1/metrics";
    private AggregationTemporality aggregationTemporality = AggregationTemporality.CUMULATIVE;
    private Map<String, String> resourceAttributes;
    private Map<String, String> headers;
    private HistogramFlavor histogramFlavor = HistogramFlavor.EXPLICIT_BUCKET_HISTOGRAM;
    private int maxScale = 20;
    private int maxBucketCount = 160;
    private TimeUnit baseTimeUnit = TimeUnit.MILLISECONDS;

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public AggregationTemporality getAggregationTemporality() {
        return this.aggregationTemporality;
    }

    public void setAggregationTemporality(AggregationTemporality aggregationTemporality) {
        this.aggregationTemporality = aggregationTemporality;
    }

    @Deprecated(since="3.2.0", forRemoval=true)
    @DeprecatedConfigurationProperty(replacement="management.opentelemetry.resource-attributes", since="3.2.0")
    public Map<String, String> getResourceAttributes() {
        return this.resourceAttributes;
    }

    @Deprecated(since="3.2.0", forRemoval=true)
    public void setResourceAttributes(Map<String, String> resourceAttributes) {
        this.resourceAttributes = resourceAttributes;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public HistogramFlavor getHistogramFlavor() {
        return this.histogramFlavor;
    }

    public void setHistogramFlavor(HistogramFlavor histogramFlavor) {
        this.histogramFlavor = histogramFlavor;
    }

    public int getMaxScale() {
        return this.maxScale;
    }

    public void setMaxScale(int maxScale) {
        this.maxScale = maxScale;
    }

    public int getMaxBucketCount() {
        return this.maxBucketCount;
    }

    public void setMaxBucketCount(int maxBucketCount) {
        this.maxBucketCount = maxBucketCount;
    }

    public TimeUnit getBaseTimeUnit() {
        return this.baseTimeUnit;
    }

    public void setBaseTimeUnit(TimeUnit baseTimeUnit) {
        this.baseTimeUnit = baseTimeUnit;
    }
}

