/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.logging.opentelemetry;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.sdk.logs.LogRecordProcessor;
import io.opentelemetry.sdk.logs.SdkLoggerProvider;
import io.opentelemetry.sdk.logs.SdkLoggerProviderBuilder;
import io.opentelemetry.sdk.logs.export.BatchLogRecordProcessor;
import io.opentelemetry.sdk.logs.export.LogRecordExporter;
import io.opentelemetry.sdk.resources.Resource;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.autoconfigure.logging.opentelemetry.SdkLoggerProviderBuilderCustomizer;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConditionalOnClass(value={SdkLoggerProvider.class, OpenTelemetry.class})
public class OpenTelemetryLoggingAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    BatchLogRecordProcessor batchLogRecordProcessor(ObjectProvider<LogRecordExporter> logRecordExporters) {
        return BatchLogRecordProcessor.builder((LogRecordExporter)LogRecordExporter.composite(logRecordExporters.orderedStream().toList())).build();
    }

    @Bean
    @ConditionalOnMissingBean
    SdkLoggerProvider otelSdkLoggerProvider(Resource resource, ObjectProvider<LogRecordProcessor> logRecordProcessors, ObjectProvider<SdkLoggerProviderBuilderCustomizer> customizers) {
        SdkLoggerProviderBuilder builder = SdkLoggerProvider.builder().setResource(resource);
        logRecordProcessors.orderedStream().forEach(arg_0 -> ((SdkLoggerProviderBuilder)builder).addLogRecordProcessor(arg_0));
        customizers.orderedStream().forEach(customizer -> customizer.customize(builder));
        return builder.build();
    }
}

