/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.cloudfoundry;

import java.util.Collection;
import java.util.List;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.boot.actuate.autoconfigure.cloudfoundry.CloudFoundryEndpointFilter;
import org.springframework.boot.actuate.autoconfigure.cloudfoundry.EndpointCloudFoundryExtension;
import org.springframework.boot.actuate.endpoint.EndpointFilter;
import org.springframework.boot.actuate.endpoint.invoke.OperationInvokerAdvisor;
import org.springframework.boot.actuate.endpoint.invoke.ParameterValueMapper;
import org.springframework.boot.actuate.endpoint.web.EndpointMediaTypes;
import org.springframework.boot.actuate.endpoint.web.ExposableWebEndpoint;
import org.springframework.boot.actuate.endpoint.web.PathMapper;
import org.springframework.boot.actuate.endpoint.web.annotation.EndpointWebExtension;
import org.springframework.boot.actuate.endpoint.web.annotation.WebEndpointDiscoverer;
import org.springframework.boot.actuate.health.HealthEndpoint;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.ImportRuntimeHints;
import org.springframework.core.annotation.MergedAnnotations;

@ImportRuntimeHints(value={CloudFoundryWebEndpointDiscovererRuntimeHints.class})
public class CloudFoundryWebEndpointDiscoverer
extends WebEndpointDiscoverer {
    public CloudFoundryWebEndpointDiscoverer(ApplicationContext applicationContext, ParameterValueMapper parameterValueMapper, EndpointMediaTypes endpointMediaTypes, List<PathMapper> endpointPathMappers, Collection<OperationInvokerAdvisor> invokerAdvisors, Collection<EndpointFilter<ExposableWebEndpoint>> filters) {
        super(applicationContext, parameterValueMapper, endpointMediaTypes, endpointPathMappers, null, invokerAdvisors, filters);
    }

    protected boolean isExtensionTypeExposed(Class<?> extensionBeanType) {
        return !this.isHealthEndpointExtension(extensionBeanType) || this.isCloudFoundryHealthEndpointExtension(extensionBeanType);
    }

    private boolean isHealthEndpointExtension(Class<?> extensionBeanType) {
        return MergedAnnotations.from(extensionBeanType).get(EndpointWebExtension.class).getValue("endpoint", Class.class).map(HealthEndpoint.class::isAssignableFrom).orElse(false);
    }

    private boolean isCloudFoundryHealthEndpointExtension(Class<?> extensionBeanType) {
        return MergedAnnotations.from(extensionBeanType).isPresent(EndpointCloudFoundryExtension.class);
    }

    static class CloudFoundryWebEndpointDiscovererRuntimeHints
    implements RuntimeHintsRegistrar {
        CloudFoundryWebEndpointDiscovererRuntimeHints() {
        }

        public void registerHints(RuntimeHints hints, ClassLoader classLoader) {
            hints.reflection().registerType(CloudFoundryEndpointFilter.class, new MemberCategory[]{MemberCategory.INVOKE_DECLARED_CONSTRUCTORS});
        }
    }
}

