/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.logging.opentelemetry.otlp;

import io.opentelemetry.exporter.otlp.http.logs.OtlpHttpLogRecordExporter;
import io.opentelemetry.exporter.otlp.http.logs.OtlpHttpLogRecordExporterBuilder;
import java.util.Locale;
import org.springframework.boot.actuate.autoconfigure.logging.opentelemetry.otlp.OtlpLoggingConnectionDetails;
import org.springframework.boot.actuate.autoconfigure.logging.opentelemetry.otlp.OtlpLoggingProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

final class OtlpLoggingConfigurations {
    private OtlpLoggingConfigurations() {
    }

    @Configuration(proxyBeanMethods=false)
    static class Exporters {
        Exporters() {
        }

        @ConditionalOnMissingBean(value={OtlpHttpLogRecordExporter.class}, type={"io.opentelemetry.exporter.otlp.logs.OtlpGrpcLogRecordExporter"})
        @ConditionalOnBean(value={OtlpLoggingConnectionDetails.class})
        @Bean
        OtlpHttpLogRecordExporter otlpHttpLogRecordExporter(OtlpLoggingProperties properties, OtlpLoggingConnectionDetails connectionDetails) {
            OtlpHttpLogRecordExporterBuilder builder = OtlpHttpLogRecordExporter.builder().setEndpoint(connectionDetails.getEndpoint()).setCompression(properties.getCompression().name().toLowerCase(Locale.US)).setTimeout(properties.getTimeout());
            properties.getHeaders().forEach((arg_0, arg_1) -> ((OtlpHttpLogRecordExporterBuilder)builder).addHeader(arg_0, arg_1));
            return builder.build();
        }
    }

    @Configuration(proxyBeanMethods=false)
    static class ConnectionDetails {
        ConnectionDetails() {
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnProperty(prefix="management.otlp.logging", name={"endpoint"})
        OtlpLoggingConnectionDetails otlpLogsConnectionDetails(OtlpLoggingProperties properties) {
            return new PropertiesOtlpLoggingConnectionDetails(properties);
        }

        static class PropertiesOtlpLoggingConnectionDetails
        implements OtlpLoggingConnectionDetails {
            private final OtlpLoggingProperties properties;

            PropertiesOtlpLoggingConnectionDetails(OtlpLoggingProperties properties) {
                this.properties = properties;
            }

            @Override
            public String getEndpoint() {
                return this.properties.getEndpoint();
            }
        }
    }
}

