/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.web.servlet;

import jakarta.servlet.Servlet;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.actuate.autoconfigure.endpoint.web.WebEndpointProperties;
import org.springframework.boot.actuate.autoconfigure.web.ManagementContextFactory;
import org.springframework.boot.actuate.autoconfigure.web.servlet.ManagementServletContext;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.servlet.ServletWebServerFactoryAutoConfiguration;
import org.springframework.boot.web.servlet.filter.ApplicationContextHeaderFilter;
import org.springframework.boot.web.servlet.server.ServletWebServerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@AutoConfiguration
@ConditionalOnClass(value={Servlet.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
public class ServletManagementContextAutoConfiguration {
    @Bean
    public ManagementContextFactory servletWebChildContextFactory() {
        return new ManagementContextFactory(WebApplicationType.SERVLET, ServletWebServerFactory.class, ServletWebServerFactoryAutoConfiguration.class);
    }

    @Bean
    public ManagementServletContext managementServletContext(WebEndpointProperties properties) {
        return properties::getBasePath;
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnProperty(prefix="management.server", name={"add-application-context-header"}, havingValue="true")
    protected static class ApplicationContextFilterConfiguration {
        protected ApplicationContextFilterConfiguration() {
        }

        @Bean
        public ApplicationContextHeaderFilter applicationContextIdFilter(ApplicationContext context) {
            return new ApplicationContextHeaderFilter(context);
        }
    }
}

