/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.web.server;

import java.util.List;
import javax.lang.model.element.Modifier;
import org.springframework.aot.generate.GeneratedMethod;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.aot.generate.MethodReference;
import org.springframework.beans.factory.aot.BeanRegistrationAotContribution;
import org.springframework.beans.factory.aot.BeanRegistrationAotProcessor;
import org.springframework.beans.factory.aot.BeanRegistrationCode;
import org.springframework.beans.factory.aot.BeanRegistrationExcludeFilter;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.RegisteredBean;
import org.springframework.boot.LazyInitializationBeanFactoryPostProcessor;
import org.springframework.boot.actuate.autoconfigure.web.ManagementContextFactory;
import org.springframework.boot.actuate.autoconfigure.web.server.EnableChildManagementContextConfiguration;
import org.springframework.boot.autoconfigure.context.PropertyPlaceholderAutoConfiguration;
import org.springframework.boot.context.event.ApplicationFailedEvent;
import org.springframework.boot.web.context.ConfigurableWebServerApplicationContext;
import org.springframework.boot.web.context.WebServerInitializedEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.AnnotationConfigRegistry;
import org.springframework.context.aot.ApplicationContextAotGenerator;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.javapoet.ClassName;
import org.springframework.util.Assert;

class ChildManagementContextInitializer
implements ApplicationListener<WebServerInitializedEvent>,
BeanRegistrationAotProcessor,
BeanRegistrationExcludeFilter {
    private final ManagementContextFactory managementContextFactory;
    private final ApplicationContext parentContext;
    private final ApplicationContextInitializer<ConfigurableApplicationContext> applicationContextInitializer;

    ChildManagementContextInitializer(ManagementContextFactory managementContextFactory, ApplicationContext parentContext) {
        this(managementContextFactory, parentContext, null);
    }

    private ChildManagementContextInitializer(ManagementContextFactory managementContextFactory, ApplicationContext parentContext, ApplicationContextInitializer<? extends ConfigurableApplicationContext> applicationContextInitializer) {
        this.managementContextFactory = managementContextFactory;
        this.parentContext = parentContext;
        this.applicationContextInitializer = applicationContextInitializer;
    }

    public void onApplicationEvent(WebServerInitializedEvent event) {
        if (event.getApplicationContext().equals(this.parentContext)) {
            ConfigurableApplicationContext managementContext = this.createManagementContext();
            this.registerBeans(managementContext);
            managementContext.refresh();
        }
    }

    public BeanRegistrationAotContribution processAheadOfTime(RegisteredBean registeredBean) {
        Assert.isInstanceOf(ConfigurableApplicationContext.class, (Object)this.parentContext);
        ConfigurableListableBeanFactory parentBeanFactory = ((ConfigurableApplicationContext)this.parentContext).getBeanFactory();
        if (registeredBean.getBeanClass().equals(this.getClass()) && registeredBean.getBeanFactory().equals(parentBeanFactory)) {
            ConfigurableApplicationContext managementContext = this.createManagementContext();
            this.registerBeans(managementContext);
            return new AotContribution(managementContext);
        }
        return null;
    }

    public boolean isExcluded(RegisteredBean registeredBean) {
        return false;
    }

    private void registerBeans(ConfigurableApplicationContext managementContext) {
        if (this.applicationContextInitializer != null) {
            this.applicationContextInitializer.initialize(managementContext);
            return;
        }
        Assert.isInstanceOf(AnnotationConfigRegistry.class, (Object)managementContext);
        AnnotationConfigRegistry registry = (AnnotationConfigRegistry)managementContext;
        this.managementContextFactory.registerWebServerFactoryBeans(this.parentContext, managementContext, registry);
        registry.register(new Class[]{EnableChildManagementContextConfiguration.class, PropertyPlaceholderAutoConfiguration.class});
        if (this.isLazyInitialization()) {
            managementContext.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)new LazyInitializationBeanFactoryPostProcessor());
        }
    }

    protected final ConfigurableApplicationContext createManagementContext() {
        ConfigurableApplicationContext managementContext = this.managementContextFactory.createManagementContext(this.parentContext);
        managementContext.setId(this.parentContext.getId() + ":management");
        if (managementContext instanceof ConfigurableWebServerApplicationContext) {
            ConfigurableWebServerApplicationContext webServerApplicationContext = (ConfigurableWebServerApplicationContext)managementContext;
            webServerApplicationContext.setServerNamespace("management");
        }
        if (managementContext instanceof DefaultResourceLoader) {
            DefaultResourceLoader resourceLoader = (DefaultResourceLoader)managementContext;
            resourceLoader.setClassLoader(this.parentContext.getClassLoader());
        }
        CloseManagementContextListener.addIfPossible(this.parentContext, managementContext);
        return managementContext;
    }

    private boolean isLazyInitialization() {
        AbstractApplicationContext context = (AbstractApplicationContext)this.parentContext;
        List postProcessors = context.getBeanFactoryPostProcessors();
        return postProcessors.stream().anyMatch(LazyInitializationBeanFactoryPostProcessor.class::isInstance);
    }

    ChildManagementContextInitializer withApplicationContextInitializer(ApplicationContextInitializer<? extends ConfigurableApplicationContext> applicationContextInitializer) {
        return new ChildManagementContextInitializer(this.managementContextFactory, this.parentContext, applicationContextInitializer);
    }

    private static class AotContribution
    implements BeanRegistrationAotContribution {
        private final GenericApplicationContext managementContext;

        AotContribution(ConfigurableApplicationContext managementContext) {
            Assert.isInstanceOf(GenericApplicationContext.class, (Object)managementContext);
            this.managementContext = (GenericApplicationContext)managementContext;
        }

        public void applyTo(GenerationContext generationContext, BeanRegistrationCode beanRegistrationCode) {
            GenerationContext managementGenerationContext = generationContext.withName("Management");
            ClassName generatedInitializerClassName = new ApplicationContextAotGenerator().generateApplicationContext(this.managementContext, managementGenerationContext);
            GeneratedMethod postProcessorMethod = beanRegistrationCode.getMethodGenerator().generateMethod(new Object[]{"addManagementInitializer"}).using(builder -> {
                builder.addJavadoc("Use AOT management context initialization", new Object[0]);
                builder.addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC});
                builder.addParameter(RegisteredBean.class, "registeredBean", new Modifier[0]);
                builder.addParameter(ChildManagementContextInitializer.class, "instance", new Modifier[0]);
                builder.returns(ChildManagementContextInitializer.class);
                builder.addStatement("return instance.withApplicationContextInitializer(new $L())", new Object[]{generatedInitializerClassName});
            });
            beanRegistrationCode.addInstancePostProcessor(MethodReference.ofStatic((ClassName)beanRegistrationCode.getClassName(), (String)postProcessorMethod.getName()));
        }
    }

    private static class CloseManagementContextListener
    implements ApplicationListener<ApplicationEvent> {
        private final ApplicationContext parentContext;
        private final ConfigurableApplicationContext childContext;

        CloseManagementContextListener(ApplicationContext parentContext, ConfigurableApplicationContext childContext) {
            this.parentContext = parentContext;
            this.childContext = childContext;
        }

        public void onApplicationEvent(ApplicationEvent event) {
            if (event instanceof ContextClosedEvent) {
                ContextClosedEvent contextClosedEvent = (ContextClosedEvent)event;
                this.onContextClosedEvent(contextClosedEvent);
            }
            if (event instanceof ApplicationFailedEvent) {
                ApplicationFailedEvent applicationFailedEvent = (ApplicationFailedEvent)event;
                this.onApplicationFailedEvent(applicationFailedEvent);
            }
        }

        private void onContextClosedEvent(ContextClosedEvent event) {
            this.propagateCloseIfNecessary(event.getApplicationContext());
        }

        private void onApplicationFailedEvent(ApplicationFailedEvent event) {
            this.propagateCloseIfNecessary((ApplicationContext)event.getApplicationContext());
        }

        private void propagateCloseIfNecessary(ApplicationContext applicationContext) {
            if (applicationContext == this.parentContext) {
                this.childContext.close();
            }
        }

        static void addIfPossible(ApplicationContext parentContext, ConfigurableApplicationContext childContext) {
            if (parentContext instanceof ConfigurableApplicationContext) {
                CloseManagementContextListener.add((ConfigurableApplicationContext)parentContext, childContext);
            }
        }

        private static void add(ConfigurableApplicationContext parentContext, ConfigurableApplicationContext childContext) {
            parentContext.addApplicationListener((ApplicationListener)new CloseManagementContextListener((ApplicationContext)parentContext, childContext));
        }
    }
}

