/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.wavefront;

import com.wavefront.sdk.common.WavefrontSender;
import com.wavefront.sdk.common.clients.WavefrontClient;
import java.time.Duration;
import org.springframework.boot.actuate.autoconfigure.wavefront.WavefrontProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.unit.DataSize;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={WavefrontSender.class})
@EnableConfigurationProperties(value={WavefrontProperties.class})
public class WavefrontSenderConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public WavefrontSender wavefrontSender(WavefrontProperties properties) {
        WavefrontClient.Builder builder = new WavefrontClient.Builder(properties.getEffectiveUri().toString(), properties.getApiTokenOrThrow());
        PropertyMapper mapper = PropertyMapper.get().alwaysApplyingWhenNonNull();
        WavefrontProperties.Sender sender = properties.getSender();
        mapper.from((Object)sender.getMaxQueueSize()).to(arg_0 -> ((WavefrontClient.Builder)builder).maxQueueSize(arg_0));
        mapper.from((Object)sender.getFlushInterval()).asInt(Duration::getSeconds).to(arg_0 -> ((WavefrontClient.Builder)builder).flushIntervalSeconds(arg_0));
        mapper.from((Object)sender.getMessageSize()).asInt(DataSize::toBytes).to(arg_0 -> ((WavefrontClient.Builder)builder).messageSizeBytes(arg_0));
        mapper.from((Object)sender.getBatchSize()).to(arg_0 -> ((WavefrontClient.Builder)builder).batchSize(arg_0));
        return builder.build();
    }
}

