/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.tracing.zipkin;

import io.opentelemetry.exporter.zipkin.ZipkinSpanExporter;
import org.springframework.boot.actuate.autoconfigure.tracing.zipkin.ZipkinProperties;
import org.springframework.boot.actuate.autoconfigure.tracing.zipkin.ZipkinRestTemplateSender;
import org.springframework.boot.actuate.autoconfigure.tracing.zipkin.ZipkinWebClientSender;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.reactive.function.client.WebClient;
import zipkin2.Span;
import zipkin2.codec.BytesEncoder;
import zipkin2.reporter.AsyncReporter;
import zipkin2.reporter.Reporter;
import zipkin2.reporter.Sender;
import zipkin2.reporter.brave.ZipkinSpanHandler;
import zipkin2.reporter.urlconnection.URLConnectionSender;

class ZipkinConfigurations {
    ZipkinConfigurations() {
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={ZipkinSpanExporter.class})
    static class OpenTelemetryConfiguration {
        OpenTelemetryConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnBean(value={Sender.class})
        ZipkinSpanExporter zipkinSpanExporter(BytesEncoder<Span> encoder, Sender sender) {
            return ZipkinSpanExporter.builder().setEncoder(encoder).setSender(sender).build();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={ZipkinSpanHandler.class})
    static class BraveConfiguration {
        BraveConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnBean(value={Reporter.class})
        ZipkinSpanHandler zipkinSpanHandler(Reporter<Span> spanReporter) {
            return (ZipkinSpanHandler)ZipkinSpanHandler.newBuilder(spanReporter).build();
        }
    }

    @Configuration(proxyBeanMethods=false)
    static class ReporterConfiguration {
        ReporterConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnBean(value={Sender.class})
        AsyncReporter<Span> spanReporter(Sender sender, BytesEncoder<Span> encoder) {
            return AsyncReporter.builder((Sender)sender).build(encoder);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
    @EnableConfigurationProperties(value={ZipkinProperties.class})
    static class WebClientSenderConfiguration {
        WebClientSenderConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={Sender.class})
        @ConditionalOnBean(value={WebClient.Builder.class})
        ZipkinWebClientSender webClientSender(ZipkinProperties properties, WebClient.Builder webClientBuilder) {
            WebClient webClient = webClientBuilder.build();
            return new ZipkinWebClientSender(properties.getEndpoint(), webClient);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={RestTemplate.class})
    @EnableConfigurationProperties(value={ZipkinProperties.class})
    static class RestTemplateSenderConfiguration {
        RestTemplateSenderConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={Sender.class})
        @ConditionalOnBean(value={RestTemplateBuilder.class})
        ZipkinRestTemplateSender restTemplateSender(ZipkinProperties properties, RestTemplateBuilder restTemplateBuilder) {
            RestTemplate restTemplate = restTemplateBuilder.setConnectTimeout(properties.getConnectTimeout()).setReadTimeout(properties.getReadTimeout()).build();
            return new ZipkinRestTemplateSender(properties.getEndpoint(), restTemplate);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={URLConnectionSender.class})
    @EnableConfigurationProperties(value={ZipkinProperties.class})
    static class UrlConnectionSenderConfiguration {
        UrlConnectionSenderConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={Sender.class})
        URLConnectionSender urlConnectionSender(ZipkinProperties properties) {
            return URLConnectionSender.newBuilder().connectTimeout((int)properties.getConnectTimeout().getSeconds()).readTimeout((int)properties.getReadTimeout().getSeconds()).endpoint(properties.getEndpoint()).build();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @Import(value={UrlConnectionSenderConfiguration.class, RestTemplateSenderConfiguration.class, WebClientSenderConfiguration.class})
    static class SenderConfiguration {
        SenderConfiguration() {
        }
    }
}

