/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.tracing;

import io.micrometer.tracing.BaggageManager;
import io.micrometer.tracing.CurrentTraceContext;
import io.micrometer.tracing.SamplerFunction;
import io.micrometer.tracing.otel.bridge.DefaultHttpClientAttributesGetter;
import io.micrometer.tracing.otel.bridge.DefaultHttpServerAttributesExtractor;
import io.micrometer.tracing.otel.bridge.OtelBaggageManager;
import io.micrometer.tracing.otel.bridge.OtelCurrentTraceContext;
import io.micrometer.tracing.otel.bridge.OtelHttpClientHandler;
import io.micrometer.tracing.otel.bridge.OtelHttpServerHandler;
import io.micrometer.tracing.otel.bridge.OtelTracer;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerAttributesGetter;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import io.opentelemetry.sdk.trace.SdkTracerProviderBuilder;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.export.BatchSpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import io.opentelemetry.semconv.resource.attributes.ResourceAttributes;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.springframework.boot.SpringBootVersion;
import org.springframework.boot.actuate.autoconfigure.tracing.TracingProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

class OpenTelemetryConfigurations {
    OpenTelemetryConfigurations() {
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={OtelTracer.class})
    static class MicrometerConfiguration {
        MicrometerConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnBean(value={Tracer.class})
        OtelTracer micrometerOtelTracer(Tracer tracer, OtelTracer.EventPublisher eventPublisher, OtelCurrentTraceContext otelCurrentTraceContext) {
            return new OtelTracer(tracer, otelCurrentTraceContext, eventPublisher, (BaggageManager)new OtelBaggageManager((CurrentTraceContext)otelCurrentTraceContext, List.of(), List.of()));
        }

        @Bean
        @ConditionalOnMissingBean
        OtelTracer.EventPublisher otelTracerEventPublisher() {
            return event -> {};
        }

        @Bean
        @ConditionalOnMissingBean
        OtelCurrentTraceContext otelCurrentTraceContext() {
            return new OtelCurrentTraceContext();
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnBean(value={OpenTelemetry.class})
        OtelHttpClientHandler otelHttpClientHandler(OpenTelemetry openTelemetry) {
            return new OtelHttpClientHandler(openTelemetry, null, null, SamplerFunction.deferDecision(), (HttpClientAttributesGetter)new DefaultHttpClientAttributesGetter());
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnBean(value={OpenTelemetry.class})
        OtelHttpServerHandler otelHttpServerHandler(OpenTelemetry openTelemetry) {
            return new OtelHttpServerHandler(openTelemetry, null, null, Pattern.compile(""), (HttpServerAttributesGetter)new DefaultHttpServerAttributesExtractor());
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={Tracer.class})
    static class TracerConfiguration {
        TracerConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnBean(value={OpenTelemetry.class})
        Tracer otelTracer(OpenTelemetry openTelemetry) {
            return openTelemetry.getTracer("org.springframework.boot", SpringBootVersion.getVersion());
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={SdkTracerProvider.class})
    @EnableConfigurationProperties(value={TracingProperties.class})
    static class SdkConfiguration {
        private static final String DEFAULT_APPLICATION_NAME = "application";

        SdkConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        OpenTelemetry openTelemetry(SdkTracerProvider sdkTracerProvider, ContextPropagators contextPropagators) {
            return OpenTelemetrySdk.builder().setTracerProvider(sdkTracerProvider).setPropagators(contextPropagators).build();
        }

        @Bean
        @ConditionalOnMissingBean
        SdkTracerProvider otelSdkTracerProvider(Environment environment, List<SpanProcessor> spanProcessors, Sampler sampler) {
            String applicationName = environment.getProperty("spring.application.name", DEFAULT_APPLICATION_NAME);
            SdkTracerProviderBuilder builder = SdkTracerProvider.builder().setSampler(sampler).setResource(Resource.create((Attributes)Attributes.of((AttributeKey)ResourceAttributes.SERVICE_NAME, (Object)applicationName)));
            for (SpanProcessor spanProcessor : spanProcessors) {
                builder.addSpanProcessor(spanProcessor);
            }
            return builder.build();
        }

        @Bean
        @ConditionalOnMissingBean
        ContextPropagators otelContextPropagators(List<TextMapPropagator> textMapPropagators) {
            return ContextPropagators.create((TextMapPropagator)TextMapPropagator.composite(textMapPropagators));
        }

        @Bean
        @ConditionalOnMissingBean
        Sampler otelSampler(TracingProperties properties) {
            return Sampler.traceIdRatioBased((double)properties.getSampling().getProbability());
        }

        @Bean
        @ConditionalOnMissingBean
        SpanProcessor otelSpanProcessor(List<SpanExporter> spanExporter) {
            return SpanProcessor.composite((Iterable)spanExporter.stream().map(exporter -> BatchSpanProcessor.builder((SpanExporter)exporter).build()).collect(Collectors.toList()));
        }
    }
}

