/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.tracing;

import org.springframework.boot.actuate.autoconfigure.tracing.ConditionalOnEnabledTracing;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;

class OnTracingEnabledCondition
extends SpringBootCondition {
    private static final String PROPERTY_NAME = "management.tracing.enabled";

    OnTracingEnabledCondition() {
    }

    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        boolean match = (Boolean)context.getEnvironment().getProperty(PROPERTY_NAME, Boolean.class, (Object)true);
        return new ConditionOutcome(match, ConditionMessage.forCondition(ConditionalOnEnabledTracing.class, (Object[])new Object[0]).because("management.tracing.enabled is " + match));
    }
}

