/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.tracing;

import io.micrometer.tracing.Tracer;
import io.micrometer.tracing.handler.DefaultTracingObservationHandler;
import io.micrometer.tracing.handler.HttpClientTracingObservationHandler;
import io.micrometer.tracing.handler.HttpServerTracingObservationHandler;
import io.micrometer.tracing.http.HttpClientHandler;
import io.micrometer.tracing.http.HttpServerHandler;
import org.springframework.boot.actuate.autoconfigure.tracing.ConditionalOnEnabledTracing;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.core.annotation.Order;

@AutoConfiguration
@ConditionalOnClass(value={Tracer.class})
@ConditionalOnEnabledTracing
public class MicrometerTracingAutoConfiguration {
    public static final int DEFAULT_TRACING_OBSERVATION_HANDLER_ORDER = 2147482647;
    public static final int HTTP_SERVER_TRACING_OBSERVATION_HANDLER_ORDER = 1000;
    public static final int HTTP_CLIENT_TRACING_OBSERVATION_HANDLER_ORDER = 2000;

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={Tracer.class})
    @Order(value=2147482647)
    public DefaultTracingObservationHandler defaultTracingObservationHandler(Tracer tracer) {
        return new DefaultTracingObservationHandler(tracer);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={Tracer.class, HttpServerHandler.class})
    @Order(value=1000)
    public HttpServerTracingObservationHandler httpServerTracingObservationHandler(Tracer tracer, HttpServerHandler httpServerHandler) {
        return new HttpServerTracingObservationHandler(tracer, httpServerHandler);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={Tracer.class, HttpClientHandler.class})
    @Order(value=2000)
    public HttpClientTracingObservationHandler httpClientTracingObservationHandler(Tracer tracer, HttpClientHandler httpClientHandler) {
        return new HttpClientTracingObservationHandler(tracer, httpClientHandler);
    }
}

