/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.tracing;

import brave.Tracer;
import brave.Tracing;
import brave.TracingCustomizer;
import brave.handler.SpanHandler;
import brave.http.HttpClientHandler;
import brave.http.HttpClientRequest;
import brave.http.HttpClientResponse;
import brave.http.HttpServerHandler;
import brave.http.HttpServerRequest;
import brave.http.HttpServerResponse;
import brave.http.HttpTracing;
import brave.propagation.B3Propagation;
import brave.propagation.CurrentTraceContext;
import brave.propagation.CurrentTraceContextCustomizer;
import brave.propagation.Propagation;
import brave.propagation.ThreadLocalCurrentTraceContext;
import brave.sampler.Sampler;
import io.micrometer.tracing.CurrentTraceContext;
import io.micrometer.tracing.brave.bridge.BraveBaggageManager;
import io.micrometer.tracing.brave.bridge.BraveCurrentTraceContext;
import io.micrometer.tracing.brave.bridge.BraveHttpClientHandler;
import io.micrometer.tracing.brave.bridge.BraveHttpServerHandler;
import io.micrometer.tracing.brave.bridge.BraveTracer;
import java.util.List;
import org.springframework.boot.actuate.autoconfigure.tracing.ConditionalOnEnabledTracing;
import org.springframework.boot.actuate.autoconfigure.tracing.MicrometerTracingAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.tracing.TracingProperties;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@AutoConfiguration(before={MicrometerTracingAutoConfiguration.class})
@ConditionalOnClass(value={Tracer.class})
@EnableConfigurationProperties(value={TracingProperties.class})
@ConditionalOnEnabledTracing
public class BraveAutoConfiguration {
    private static final String DEFAULT_APPLICATION_NAME = "application";

    @Bean
    @ConditionalOnMissingBean
    public Tracing braveTracing(Environment environment, List<SpanHandler> spanHandlers, List<TracingCustomizer> tracingCustomizers, brave.propagation.CurrentTraceContext currentTraceContext, Propagation.Factory propagationFactory, Sampler sampler) {
        String applicationName = environment.getProperty("spring.application.name", DEFAULT_APPLICATION_NAME);
        Tracing.Builder builder = Tracing.newBuilder().currentTraceContext(currentTraceContext).propagationFactory(propagationFactory).sampler(sampler).localServiceName(applicationName);
        for (SpanHandler spanHandler : spanHandlers) {
            builder.addSpanHandler(spanHandler);
        }
        for (TracingCustomizer tracingCustomizer : tracingCustomizers) {
            tracingCustomizer.customize(builder);
        }
        return builder.build();
    }

    @Bean
    @ConditionalOnMissingBean
    public Tracer braveTracer(Tracing tracing) {
        return tracing.tracer();
    }

    @Bean
    @ConditionalOnMissingBean
    public brave.propagation.CurrentTraceContext braveCurrentTraceContext(List<CurrentTraceContext.ScopeDecorator> scopeDecorators, List<CurrentTraceContextCustomizer> currentTraceContextCustomizers) {
        ThreadLocalCurrentTraceContext.Builder builder = ThreadLocalCurrentTraceContext.newBuilder();
        for (CurrentTraceContext.ScopeDecorator scopeDecorator : scopeDecorators) {
            builder.addScopeDecorator(scopeDecorator);
        }
        for (CurrentTraceContextCustomizer currentTraceContextCustomizer : currentTraceContextCustomizers) {
            currentTraceContextCustomizer.customize((CurrentTraceContext.Builder)builder);
        }
        return builder.build();
    }

    @Bean
    @ConditionalOnMissingBean
    public Propagation.Factory bravePropagationFactory() {
        return B3Propagation.newFactoryBuilder().injectFormat(B3Propagation.Format.SINGLE_NO_PARENT).build();
    }

    @Bean
    @ConditionalOnMissingBean
    public Sampler braveSampler(TracingProperties properties) {
        return Sampler.create((float)properties.getSampling().getProbability());
    }

    @Bean
    @ConditionalOnMissingBean
    public HttpTracing httpTracing(Tracing tracing) {
        return HttpTracing.newBuilder((Tracing)tracing).build();
    }

    @Bean
    @ConditionalOnMissingBean
    public HttpServerHandler<HttpServerRequest, HttpServerResponse> httpServerHandler(HttpTracing httpTracing) {
        return HttpServerHandler.create((HttpTracing)httpTracing);
    }

    @Bean
    @ConditionalOnMissingBean
    public HttpClientHandler<HttpClientRequest, HttpClientResponse> httpClientHandler(HttpTracing httpTracing) {
        return HttpClientHandler.create((HttpTracing)httpTracing);
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={BraveTracer.class})
    static class BraveMicrometer {
        BraveMicrometer() {
        }

        @Bean
        @ConditionalOnMissingBean
        BraveTracer braveTracerBridge(Tracer tracer, brave.propagation.CurrentTraceContext currentTraceContext, BraveBaggageManager braveBaggageManager) {
            return new BraveTracer(tracer, (CurrentTraceContext)new BraveCurrentTraceContext(currentTraceContext), braveBaggageManager);
        }

        @Bean
        @ConditionalOnMissingBean
        BraveBaggageManager braveBaggageManager() {
            return new BraveBaggageManager();
        }

        @Bean
        @ConditionalOnMissingBean
        BraveHttpServerHandler braveHttpServerHandler(HttpServerHandler<HttpServerRequest, HttpServerResponse> httpServerHandler) {
            return new BraveHttpServerHandler(httpServerHandler);
        }

        @Bean
        @ConditionalOnMissingBean
        BraveHttpClientHandler braveHttpClientHandler(HttpClientHandler<HttpClientRequest, HttpClientResponse> httpClientHandler) {
            return new BraveHttpClientHandler(httpClientHandler);
        }
    }
}

