/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.security.servlet;

import org.springframework.boot.actuate.autoconfigure.web.ManagementContextConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.security.servlet.AntPathRequestMatcherProvider;
import org.springframework.boot.autoconfigure.security.servlet.RequestMatcherProvider;
import org.springframework.boot.autoconfigure.web.servlet.DispatcherServletPath;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.servlet.DispatcherServlet;

@ManagementContextConfiguration(proxyBeanMethods=false)
@ConditionalOnClass(value={RequestMatcher.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
public class SecurityRequestMatchersManagementContextConfiguration {

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={DispatcherServlet.class})
    @ConditionalOnBean(value={DispatcherServletPath.class})
    public static class MvcRequestMatcherConfiguration {
        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnClass(value={DispatcherServlet.class})
        public RequestMatcherProvider requestMatcherProvider(DispatcherServletPath servletPath) {
            return new AntPathRequestMatcherProvider(arg_0 -> ((DispatcherServletPath)servletPath).getRelativePath(arg_0));
        }
    }
}

