/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.observation;

import io.micrometer.core.instrument.observation.MeterObservationHandler;
import io.micrometer.observation.ObservationHandler;
import io.micrometer.observation.ObservationRegistry;
import io.micrometer.tracing.handler.TracingObservationHandler;
import java.util.ArrayList;
import java.util.Collection;
import org.springframework.boot.actuate.autoconfigure.observation.ObservationHandlerGrouping;

class TracingObservationHandlerGrouping
implements ObservationHandlerGrouping {
    TracingObservationHandlerGrouping() {
    }

    @Override
    public void apply(Collection<ObservationHandler<?>> handlers, ObservationRegistry.ObservationConfig config) {
        ArrayList meterObservationHandlers = new ArrayList();
        ArrayList tracingObservationHandlers = new ArrayList();
        for (ObservationHandler<?> handler : handlers) {
            if (handler instanceof MeterObservationHandler) {
                meterObservationHandlers.add(handler);
                continue;
            }
            if (handler instanceof TracingObservationHandler) {
                tracingObservationHandlers.add(handler);
                continue;
            }
            config.observationHandler(handler);
        }
        if (!meterObservationHandlers.isEmpty()) {
            config.observationHandler((ObservationHandler)new ObservationHandler.FirstMatchingCompositeObservationHandler(meterObservationHandlers));
        }
        if (!tracingObservationHandlers.isEmpty()) {
            config.observationHandler((ObservationHandler)new ObservationHandler.FirstMatchingCompositeObservationHandler(tracingObservationHandlers));
        }
    }
}

