/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.observation;

import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationHandler;
import io.micrometer.observation.ObservationPredicate;
import io.micrometer.observation.ObservationRegistry;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.actuate.autoconfigure.observation.ObservationHandlerGrouping;
import org.springframework.boot.actuate.autoconfigure.observation.ObservationRegistryConfigurer;
import org.springframework.boot.actuate.autoconfigure.observation.ObservationRegistryCustomizer;

class ObservationRegistryPostProcessor
implements BeanPostProcessor {
    private final ObjectProvider<ObservationRegistryCustomizer<?>> observationRegistryCustomizers;
    private final ObjectProvider<ObservationPredicate> observationPredicates;
    private final ObjectProvider<Observation.GlobalKeyValuesProvider<?>> keyValuesProviders;
    private final ObjectProvider<ObservationHandler<?>> observationHandlers;
    private final ObjectProvider<ObservationHandlerGrouping> observationHandlerGrouping;
    private volatile ObservationRegistryConfigurer configurer;

    ObservationRegistryPostProcessor(ObjectProvider<ObservationRegistryCustomizer<?>> observationRegistryCustomizers, ObjectProvider<ObservationPredicate> observationPredicates, ObjectProvider<Observation.GlobalKeyValuesProvider<?>> keyValuesProviders, ObjectProvider<ObservationHandler<?>> observationHandlers, ObjectProvider<ObservationHandlerGrouping> observationHandlerGrouping) {
        this.observationRegistryCustomizers = observationRegistryCustomizers;
        this.observationPredicates = observationPredicates;
        this.keyValuesProviders = keyValuesProviders;
        this.observationHandlers = observationHandlers;
        this.observationHandlerGrouping = observationHandlerGrouping;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof ObservationRegistry) {
            ObservationRegistry registry = (ObservationRegistry)bean;
            this.getConfigurer().configure(registry);
        }
        return bean;
    }

    private ObservationRegistryConfigurer getConfigurer() {
        if (this.configurer == null) {
            this.configurer = new ObservationRegistryConfigurer(this.observationRegistryCustomizers, this.observationPredicates, this.keyValuesProviders, this.observationHandlers, this.observationHandlerGrouping);
        }
        return this.configurer;
    }
}

