/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.observation;

import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationHandler;
import io.micrometer.observation.ObservationPredicate;
import io.micrometer.observation.ObservationRegistry;
import java.util.List;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.autoconfigure.observation.ObservationHandlerGrouping;
import org.springframework.boot.actuate.autoconfigure.observation.ObservationRegistryCustomizer;
import org.springframework.boot.util.LambdaSafe;

class ObservationRegistryConfigurer {
    private final ObjectProvider<ObservationRegistryCustomizer<?>> customizers;
    private final ObjectProvider<ObservationPredicate> observationPredicates;
    private final ObjectProvider<Observation.GlobalKeyValuesProvider<?>> keyValuesProviders;
    private final ObjectProvider<ObservationHandler<?>> observationHandlers;
    private final ObjectProvider<ObservationHandlerGrouping> observationHandlerGrouping;

    ObservationRegistryConfigurer(ObjectProvider<ObservationRegistryCustomizer<?>> customizers, ObjectProvider<ObservationPredicate> observationPredicates, ObjectProvider<Observation.GlobalKeyValuesProvider<?>> keyValuesProviders, ObjectProvider<ObservationHandler<?>> observationHandlers, ObjectProvider<ObservationHandlerGrouping> observationHandlerGrouping) {
        this.customizers = customizers;
        this.observationPredicates = observationPredicates;
        this.keyValuesProviders = keyValuesProviders;
        this.observationHandlers = observationHandlers;
        this.observationHandlerGrouping = observationHandlerGrouping;
    }

    void configure(ObservationRegistry registry) {
        this.registerObservationPredicates(registry);
        this.registerGlobalKeyValuesProviders(registry);
        this.registerHandlers(registry);
        this.customize(registry);
    }

    private void registerHandlers(ObservationRegistry registry) {
        ((ObservationHandlerGrouping)this.observationHandlerGrouping.getObject()).apply(this.asOrderedList(this.observationHandlers), registry.observationConfig());
    }

    private void registerObservationPredicates(ObservationRegistry registry) {
        this.observationPredicates.orderedStream().forEach(observationPredicate -> registry.observationConfig().observationPredicate(observationPredicate));
    }

    private void registerGlobalKeyValuesProviders(ObservationRegistry registry) {
        this.keyValuesProviders.orderedStream().forEach(keyValuesProvider -> registry.observationConfig().keyValuesProvider(keyValuesProvider));
    }

    private void customize(ObservationRegistry registry) {
        ((LambdaSafe.Callbacks)LambdaSafe.callbacks(ObservationRegistryCustomizer.class, this.asOrderedList(this.customizers), (Object)registry, (Object[])new Object[0]).withLogger(ObservationRegistryConfigurer.class)).invoke(customizer -> customizer.customize(registry));
    }

    private <T> List<T> asOrderedList(ObjectProvider<T> provider) {
        return provider.orderedStream().toList();
    }
}

