/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.observation;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationHandler;
import io.micrometer.observation.ObservationPredicate;
import io.micrometer.observation.ObservationRegistry;
import io.micrometer.tracing.handler.TracingObservationHandler;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.autoconfigure.metrics.CompositeMeterRegistryAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.observation.ObservationHandlerGrouping;
import org.springframework.boot.actuate.autoconfigure.observation.ObservationRegistryCustomizer;
import org.springframework.boot.actuate.autoconfigure.observation.ObservationRegistryPostProcessor;
import org.springframework.boot.actuate.autoconfigure.observation.OnlyMetricsObservationHandlerGrouping;
import org.springframework.boot.actuate.autoconfigure.observation.TimerObservationHandlerObservationRegistryCustomizer;
import org.springframework.boot.actuate.autoconfigure.observation.TracingObservationHandlerGrouping;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@AutoConfiguration(after={CompositeMeterRegistryAutoConfiguration.class})
@ConditionalOnClass(value={ObservationRegistry.class})
public class ObservationAutoConfiguration {
    @Bean
    static ObservationRegistryPostProcessor observationRegistryPostProcessor(ObjectProvider<ObservationRegistryCustomizer<?>> observationRegistryCustomizers, ObjectProvider<ObservationPredicate> observationPredicates, ObjectProvider<Observation.GlobalKeyValuesProvider<?>> keyValuesProviders, ObjectProvider<ObservationHandler<?>> observationHandlers, ObjectProvider<ObservationHandlerGrouping> observationHandlerGrouping) {
        return new ObservationRegistryPostProcessor(observationRegistryCustomizers, observationPredicates, keyValuesProviders, observationHandlers, observationHandlerGrouping);
    }

    @Bean
    @ConditionalOnMissingBean
    ObservationRegistry observationRegistry() {
        return ObservationRegistry.create();
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={TracingObservationHandler.class})
    static class TracingConfiguration {
        TracingConfiguration() {
        }

        @Bean
        TracingObservationHandlerGrouping tracingObservationHandlerGrouping() {
            return new TracingObservationHandlerGrouping();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingClass(value={"io.micrometer.tracing.handler.TracingObservationHandler"})
    static class OnlyMetricsConfiguration {
        OnlyMetricsConfiguration() {
        }

        @Bean
        OnlyMetricsObservationHandlerGrouping onlyMetricsObservationHandlerGrouping() {
            return new OnlyMetricsObservationHandlerGrouping();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBean(value={MeterRegistry.class})
    static class MetricsConfiguration {
        MetricsConfiguration() {
        }

        @Bean
        TimerObservationHandlerObservationRegistryCustomizer enableTimerObservationHandler(MeterRegistry meterRegistry) {
            return new TimerObservationHandlerObservationRegistryCustomizer(meterRegistry);
        }
    }
}

