/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.metrics.export.wavefront;

import com.wavefront.sdk.common.WavefrontSender;
import io.micrometer.core.instrument.Clock;
import io.micrometer.wavefront.WavefrontConfig;
import io.micrometer.wavefront.WavefrontMeterRegistry;
import org.springframework.boot.actuate.autoconfigure.metrics.CompositeMeterRegistryAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.MetricsAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.export.ConditionalOnEnabledMetricsExport;
import org.springframework.boot.actuate.autoconfigure.metrics.export.simple.SimpleMetricsExportAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.export.wavefront.WavefrontPropertiesConfigAdapter;
import org.springframework.boot.actuate.autoconfigure.wavefront.WavefrontProperties;
import org.springframework.boot.actuate.autoconfigure.wavefront.WavefrontSenderConfiguration;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;

@AutoConfiguration(before={CompositeMeterRegistryAutoConfiguration.class, SimpleMetricsExportAutoConfiguration.class}, after={MetricsAutoConfiguration.class})
@ConditionalOnBean(value={Clock.class, WavefrontSender.class})
@ConditionalOnClass(value={WavefrontMeterRegistry.class, WavefrontSender.class})
@ConditionalOnEnabledMetricsExport(value="wavefront")
@EnableConfigurationProperties(value={WavefrontProperties.class})
@Import(value={WavefrontSenderConfiguration.class})
public class WavefrontMetricsExportAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public WavefrontConfig wavefrontConfig(WavefrontProperties properties) {
        return new WavefrontPropertiesConfigAdapter(properties);
    }

    @Bean
    @ConditionalOnMissingBean
    public WavefrontMeterRegistry wavefrontMeterRegistry(WavefrontConfig wavefrontConfig, Clock clock, WavefrontSender wavefrontSender) {
        return WavefrontMeterRegistry.builder((WavefrontConfig)wavefrontConfig).clock(clock).wavefrontSender(wavefrontSender).build();
    }
}

