/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.health;

import java.util.Collection;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.actuate.autoconfigure.endpoint.expose.EndpointExposure;
import org.springframework.boot.actuate.autoconfigure.health.HealthEndpointProperties;
import org.springframework.boot.actuate.endpoint.web.ExposableWebEndpoint;
import org.springframework.boot.actuate.endpoint.web.WebEndpointsSupplier;
import org.springframework.boot.actuate.endpoint.web.WebServerNamespace;
import org.springframework.boot.actuate.endpoint.web.servlet.AdditionalHealthEndpointPathsWebMvcHandlerMapping;
import org.springframework.boot.actuate.health.HealthContributorRegistry;
import org.springframework.boot.actuate.health.HealthEndpoint;
import org.springframework.boot.actuate.health.HealthEndpointGroups;
import org.springframework.boot.actuate.health.HealthEndpointWebExtension;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.DispatcherServlet;

@Configuration(proxyBeanMethods=false)
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnBean(value={HealthEndpoint.class})
@ConditionalOnAvailableEndpoint(endpoint=HealthEndpoint.class, exposure={EndpointExposure.WEB, EndpointExposure.CLOUD_FOUNDRY})
class HealthEndpointWebExtensionConfiguration {
    HealthEndpointWebExtensionConfiguration() {
    }

    @Bean
    @ConditionalOnMissingBean
    HealthEndpointWebExtension healthEndpointWebExtension(HealthContributorRegistry healthContributorRegistry, HealthEndpointGroups groups, HealthEndpointProperties properties) {
        return new HealthEndpointWebExtension(healthContributorRegistry, groups, properties.getLogging().getSlowIndicatorThreshold());
    }

    private static ExposableWebEndpoint getHealthEndpoint(WebEndpointsSupplier webEndpointsSupplier) {
        Collection webEndpoints = webEndpointsSupplier.getEndpoints();
        return webEndpoints.stream().filter(endpoint -> endpoint.getEndpointId().equals((Object)HealthEndpoint.ID)).findFirst().get();
    }

    @ConditionalOnBean(value={DispatcherServlet.class})
    @ConditionalOnAvailableEndpoint(endpoint=HealthEndpoint.class, exposure={EndpointExposure.WEB})
    static class MvcAdditionalHealthEndpointPathsConfiguration {
        MvcAdditionalHealthEndpointPathsConfiguration() {
        }

        @Bean
        AdditionalHealthEndpointPathsWebMvcHandlerMapping healthEndpointWebMvcHandlerMapping(WebEndpointsSupplier webEndpointsSupplier, HealthEndpointGroups groups) {
            ExposableWebEndpoint health = HealthEndpointWebExtensionConfiguration.getHealthEndpoint(webEndpointsSupplier);
            return new AdditionalHealthEndpointPathsWebMvcHandlerMapping(health, groups.getAllWithAdditionalPath(WebServerNamespace.SERVER));
        }
    }
}

