/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.health;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.BeanFactoryAnnotationUtils;
import org.springframework.boot.actuate.autoconfigure.health.AutoConfiguredHealthEndpointGroup;
import org.springframework.boot.actuate.autoconfigure.health.HealthEndpointProperties;
import org.springframework.boot.actuate.autoconfigure.health.HealthProperties;
import org.springframework.boot.actuate.autoconfigure.health.IncludeExcludeGroupMemberPredicate;
import org.springframework.boot.actuate.health.AdditionalHealthEndpointPath;
import org.springframework.boot.actuate.health.HealthEndpointGroup;
import org.springframework.boot.actuate.health.HealthEndpointGroups;
import org.springframework.boot.actuate.health.HttpCodeStatusMapper;
import org.springframework.boot.actuate.health.SimpleHttpCodeStatusMapper;
import org.springframework.boot.actuate.health.SimpleStatusAggregator;
import org.springframework.boot.actuate.health.StatusAggregator;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

class AutoConfiguredHealthEndpointGroups
implements HealthEndpointGroups {
    private static final Predicate<String> ALL = name -> true;
    private final HealthEndpointGroup primaryGroup;
    private final Map<String, HealthEndpointGroup> groups;

    AutoConfiguredHealthEndpointGroups(ApplicationContext applicationContext, HealthEndpointProperties properties) {
        HttpCodeStatusMapper httpCodeStatusMapper;
        ApplicationContext applicationContext2;
        if (applicationContext instanceof ConfigurableApplicationContext) {
            ConfigurableApplicationContext configurableContext = (ConfigurableApplicationContext)applicationContext;
            applicationContext2 = configurableContext.getBeanFactory();
        } else {
            applicationContext2 = applicationContext;
        }
        ApplicationContext beanFactory = applicationContext2;
        HealthProperties.Show showComponents = properties.getShowComponents();
        HealthProperties.Show showDetails = properties.getShowDetails();
        Set<String> roles = properties.getRoles();
        StatusAggregator statusAggregator = this.getNonQualifiedBean((ListableBeanFactory)beanFactory, StatusAggregator.class);
        if (statusAggregator == null) {
            statusAggregator = new SimpleStatusAggregator(properties.getStatus().getOrder());
        }
        if ((httpCodeStatusMapper = this.getNonQualifiedBean((ListableBeanFactory)beanFactory, HttpCodeStatusMapper.class)) == null) {
            httpCodeStatusMapper = new SimpleHttpCodeStatusMapper(properties.getStatus().getHttpMapping());
        }
        this.primaryGroup = new AutoConfiguredHealthEndpointGroup(ALL, statusAggregator, httpCodeStatusMapper, showComponents, showDetails, roles, null);
        this.groups = this.createGroups(properties.getGroup(), (BeanFactory)beanFactory, statusAggregator, httpCodeStatusMapper, showComponents, showDetails, roles);
    }

    private Map<String, HealthEndpointGroup> createGroups(Map<String, HealthEndpointProperties.Group> groupProperties, BeanFactory beanFactory, StatusAggregator defaultStatusAggregator, HttpCodeStatusMapper defaultHttpCodeStatusMapper, HealthProperties.Show defaultShowComponents, HealthProperties.Show defaultShowDetails, Set<String> defaultRoles) {
        LinkedHashMap groups = new LinkedHashMap();
        groupProperties.forEach((groupName, group) -> {
            HealthProperties.Status status = group.getStatus();
            HealthProperties.Show showComponents = group.getShowComponents() != null ? group.getShowComponents() : defaultShowComponents;
            HealthProperties.Show showDetails = group.getShowDetails() != null ? group.getShowDetails() : defaultShowDetails;
            Set<String> roles = !CollectionUtils.isEmpty(group.getRoles()) ? group.getRoles() : defaultRoles;
            StatusAggregator statusAggregator = this.getQualifiedBean(beanFactory, (Class)StatusAggregator.class, (String)groupName, () -> {
                if (!CollectionUtils.isEmpty(status.getOrder())) {
                    return new SimpleStatusAggregator(status.getOrder());
                }
                return defaultStatusAggregator;
            });
            HttpCodeStatusMapper httpCodeStatusMapper = this.getQualifiedBean(beanFactory, (Class)HttpCodeStatusMapper.class, (String)groupName, () -> {
                if (!CollectionUtils.isEmpty(status.getHttpMapping())) {
                    return new SimpleHttpCodeStatusMapper(status.getHttpMapping());
                }
                return defaultHttpCodeStatusMapper;
            });
            IncludeExcludeGroupMemberPredicate members = new IncludeExcludeGroupMemberPredicate(group.getInclude(), group.getExclude());
            AdditionalHealthEndpointPath additionalPath = group.getAdditionalPath() != null ? AdditionalHealthEndpointPath.from((String)group.getAdditionalPath()) : null;
            groups.put(groupName, new AutoConfiguredHealthEndpointGroup(members, statusAggregator, httpCodeStatusMapper, showComponents, showDetails, roles, additionalPath));
        });
        return Collections.unmodifiableMap(groups);
    }

    private <T> T getNonQualifiedBean(ListableBeanFactory beanFactory, Class<T> type) {
        ArrayList<String> candidates = new ArrayList<String>();
        for (String beanName : BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)beanFactory, type)) {
            String[] aliases = beanFactory.getAliases(beanName);
            if (BeanFactoryAnnotationUtils.isQualifierMatch(qualifier -> !qualifier.equals(beanName) && !ObjectUtils.containsElement((Object[])aliases, (Object)qualifier), (String)beanName, (BeanFactory)beanFactory)) continue;
            candidates.add(beanName);
        }
        if (candidates.isEmpty()) {
            return null;
        }
        if (candidates.size() == 1) {
            return (T)beanFactory.getBean((String)candidates.get(0), type);
        }
        return (T)beanFactory.getBean(type);
    }

    private <T> T getQualifiedBean(BeanFactory beanFactory, Class<T> type, String qualifier, Supplier<T> fallback) {
        try {
            return (T)BeanFactoryAnnotationUtils.qualifiedBeanOfType((BeanFactory)beanFactory, type, (String)qualifier);
        }
        catch (NoSuchBeanDefinitionException ex) {
            return fallback.get();
        }
    }

    public HealthEndpointGroup getPrimary() {
        return this.primaryGroup;
    }

    public Set<String> getNames() {
        return this.groups.keySet();
    }

    public HealthEndpointGroup get(String name) {
        return this.groups.get(name);
    }
}

