/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.elasticsearch;

import java.util.Map;
import org.springframework.boot.actuate.autoconfigure.health.CompositeReactiveHealthContributorConfiguration;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.elasticsearch.ElasticsearchReactiveHealthIndicator;
import org.springframework.boot.actuate.health.ReactiveHealthContributor;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.elasticsearch.ReactiveElasticsearchClientAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.data.elasticsearch.client.elc.ReactiveElasticsearchClient;
import reactor.core.publisher.Flux;

@AutoConfiguration(after={ReactiveElasticsearchClientAutoConfiguration.class})
@ConditionalOnClass(value={ReactiveElasticsearchClient.class, Flux.class})
@ConditionalOnBean(value={ReactiveElasticsearchClient.class})
@ConditionalOnEnabledHealthIndicator(value="elasticsearch")
public class ElasticsearchReactiveHealthContributorAutoConfiguration
extends CompositeReactiveHealthContributorConfiguration<ElasticsearchReactiveHealthIndicator, ReactiveElasticsearchClient> {
    @Bean
    @ConditionalOnMissingBean(name={"elasticsearchHealthIndicator", "elasticsearchHealthContributor"})
    public ReactiveHealthContributor elasticsearchHealthContributor(Map<String, ReactiveElasticsearchClient> clients) {
        return (ReactiveHealthContributor)this.createContributor(clients);
    }
}

