/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.metrics.export.newrelic;

import io.micrometer.core.instrument.Clock;
import io.micrometer.newrelic.NewRelicClientProvider;
import io.micrometer.newrelic.NewRelicConfig;
import io.micrometer.newrelic.NewRelicMeterRegistry;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.autoconfigure.metrics.CompositeMeterRegistryAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.MetricsAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.export.newrelic.NewRelicProperties;
import org.springframework.boot.actuate.autoconfigure.metrics.export.newrelic.NewRelicPropertiesConfigAdapter;
import org.springframework.boot.actuate.autoconfigure.metrics.export.simple.SimpleMetricsExportAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@AutoConfigureBefore(value={CompositeMeterRegistryAutoConfiguration.class, SimpleMetricsExportAutoConfiguration.class})
@AutoConfigureAfter(value={MetricsAutoConfiguration.class})
@ConditionalOnBean(value={Clock.class})
@ConditionalOnClass(value={NewRelicMeterRegistry.class})
@ConditionalOnProperty(prefix="management.metrics.export.newrelic", name={"enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={NewRelicProperties.class})
public class NewRelicMetricsExportAutoConfiguration {
    private final NewRelicProperties properties;

    public NewRelicMetricsExportAutoConfiguration(NewRelicProperties properties) {
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean
    public NewRelicConfig newRelicConfig() {
        return new NewRelicPropertiesConfigAdapter(this.properties);
    }

    @Bean
    @ConditionalOnMissingBean
    public NewRelicMeterRegistry newRelicMeterRegistry(NewRelicConfig newRelicConfig, Clock clock, ObjectProvider<NewRelicClientProvider> newRelicClientProvider) {
        NewRelicMeterRegistry.Builder builder = NewRelicMeterRegistry.builder((NewRelicConfig)newRelicConfig).clock(clock);
        newRelicClientProvider.ifUnique(arg_0 -> ((NewRelicMeterRegistry.Builder)builder).clientProvider(arg_0));
        return builder.build();
    }
}

