/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.metrics;

import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.boot.actuate.autoconfigure.metrics.AutoTimeProperties;
import org.springframework.boot.actuate.autoconfigure.metrics.ServiceLevelAgreementBoundary;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.DeprecatedConfigurationProperty;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

@ConfigurationProperties(value="management.metrics")
public class MetricsProperties {
    private boolean useGlobalRegistry = true;
    private final Map<String, Boolean> enable = new LinkedHashMap<String, Boolean>();
    private final Map<String, String> tags = new LinkedHashMap<String, String>();
    private final Web web = new Web();
    private final Distribution distribution = new Distribution();

    public boolean isUseGlobalRegistry() {
        return this.useGlobalRegistry;
    }

    public void setUseGlobalRegistry(boolean useGlobalRegistry) {
        this.useGlobalRegistry = useGlobalRegistry;
    }

    public Map<String, Boolean> getEnable() {
        return this.enable;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public Web getWeb() {
        return this.web;
    }

    public Distribution getDistribution() {
        return this.distribution;
    }

    public static class Distribution {
        private final Map<String, Boolean> percentilesHistogram = new LinkedHashMap<String, Boolean>();
        private final Map<String, double[]> percentiles = new LinkedHashMap<String, double[]>();
        private final Map<String, ServiceLevelAgreementBoundary[]> sla = new LinkedHashMap<String, ServiceLevelAgreementBoundary[]>();
        private final Map<String, String> minimumExpectedValue = new LinkedHashMap<String, String>();
        private final Map<String, String> maximumExpectedValue = new LinkedHashMap<String, String>();

        public Map<String, Boolean> getPercentilesHistogram() {
            return this.percentilesHistogram;
        }

        public Map<String, double[]> getPercentiles() {
            return this.percentiles;
        }

        public Map<String, ServiceLevelAgreementBoundary[]> getSla() {
            return this.sla;
        }

        public Map<String, String> getMinimumExpectedValue() {
            return this.minimumExpectedValue;
        }

        public Map<String, String> getMaximumExpectedValue() {
            return this.maximumExpectedValue;
        }
    }

    public static class Web {
        private final Client client = new Client();
        private final Server server = new Server();

        public Client getClient() {
            return this.client;
        }

        public Server getServer() {
            return this.server;
        }

        public static class Server {
            private final ServerRequest request = new ServerRequest();
            private int maxUriTags = 100;

            public ServerRequest getRequest() {
                return this.request;
            }

            @DeprecatedConfigurationProperty(replacement="management.metrics.web.server.request.autotime.enabled")
            @Deprecated
            public boolean isAutoTimeRequests() {
                return this.request.getAutotime().isEnabled();
            }

            @Deprecated
            public void setAutoTimeRequests(boolean autoTimeRequests) {
                this.request.getAutotime().setEnabled(autoTimeRequests);
            }

            @DeprecatedConfigurationProperty(replacement="management.metrics.web.server.request.metric-name")
            @Deprecated
            public String getRequestsMetricName() {
                return this.request.getMetricName();
            }

            @Deprecated
            public void setRequestsMetricName(String requestsMetricName) {
                this.request.setMetricName(requestsMetricName);
            }

            public int getMaxUriTags() {
                return this.maxUriTags;
            }

            public void setMaxUriTags(int maxUriTags) {
                this.maxUriTags = maxUriTags;
            }

            public static class ServerRequest {
                private String metricName = "http.server.requests";
                private boolean ignoreTrailingSlash = true;
                @NestedConfigurationProperty
                private final AutoTimeProperties autotime = new AutoTimeProperties();

                public AutoTimeProperties getAutotime() {
                    return this.autotime;
                }

                public String getMetricName() {
                    return this.metricName;
                }

                public void setMetricName(String metricName) {
                    this.metricName = metricName;
                }

                public boolean isIgnoreTrailingSlash() {
                    return this.ignoreTrailingSlash;
                }

                public void setIgnoreTrailingSlash(boolean ignoreTrailingSlash) {
                    this.ignoreTrailingSlash = ignoreTrailingSlash;
                }
            }
        }

        public static class Client {
            private final ClientRequest request = new ClientRequest();
            private int maxUriTags = 100;

            public ClientRequest getRequest() {
                return this.request;
            }

            @Deprecated
            @DeprecatedConfigurationProperty(replacement="management.metrics.web.client.request.metric-name")
            public String getRequestsMetricName() {
                return this.request.getMetricName();
            }

            @Deprecated
            public void setRequestsMetricName(String requestsMetricName) {
                this.request.setMetricName(requestsMetricName);
            }

            public int getMaxUriTags() {
                return this.maxUriTags;
            }

            public void setMaxUriTags(int maxUriTags) {
                this.maxUriTags = maxUriTags;
            }

            public static class ClientRequest {
                private String metricName = "http.client.requests";
                @NestedConfigurationProperty
                private final AutoTimeProperties autotime = new AutoTimeProperties();

                public AutoTimeProperties getAutotime() {
                    return this.autotime;
                }

                public String getMetricName() {
                    return this.metricName;
                }

                public void setMetricName(String metricName) {
                    this.metricName = metricName;
                }
            }
        }
    }
}

