/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.health;

import java.util.Map;
import org.springframework.boot.actuate.autoconfigure.health.AutoConfiguredHealthContributorRegistry;
import org.springframework.boot.actuate.autoconfigure.health.AutoConfiguredHealthEndpointGroups;
import org.springframework.boot.actuate.autoconfigure.health.HealthEndpointProperties;
import org.springframework.boot.actuate.health.HealthContributor;
import org.springframework.boot.actuate.health.HealthContributorRegistry;
import org.springframework.boot.actuate.health.HealthEndpoint;
import org.springframework.boot.actuate.health.HealthEndpointGroups;
import org.springframework.boot.actuate.health.HttpCodeStatusMapper;
import org.springframework.boot.actuate.health.SimpleHttpCodeStatusMapper;
import org.springframework.boot.actuate.health.SimpleStatusAggregator;
import org.springframework.boot.actuate.health.StatusAggregator;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
class HealthEndpointConfiguration {
    HealthEndpointConfiguration() {
    }

    @Bean
    @ConditionalOnMissingBean
    StatusAggregator healthStatusAggregator(HealthEndpointProperties properties) {
        return new SimpleStatusAggregator(properties.getStatus().getOrder());
    }

    @Bean
    @ConditionalOnMissingBean
    HttpCodeStatusMapper healthHttpCodeStatusMapper(HealthEndpointProperties properties) {
        return new SimpleHttpCodeStatusMapper(properties.getStatus().getHttpMapping());
    }

    @Bean
    @ConditionalOnMissingBean
    HealthEndpointGroups healthEndpointGroups(ApplicationContext applicationContext, HealthEndpointProperties properties) {
        return new AutoConfiguredHealthEndpointGroups(applicationContext, properties);
    }

    @Bean
    @ConditionalOnMissingBean
    HealthContributorRegistry healthContributorRegistry(Map<String, HealthContributor> healthContributors, HealthEndpointGroups groups) {
        return new AutoConfiguredHealthContributorRegistry(healthContributors, groups.getNames());
    }

    @Bean
    @ConditionalOnMissingBean
    HealthEndpoint healthEndpoint(HealthContributorRegistry registry, HealthEndpointGroups groups) {
        return new HealthEndpoint(registry, groups);
    }
}

