/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.endpoint.condition;

import java.util.Optional;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.AbstractEndpointCondition;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnEnabledEndpoint;
import org.springframework.boot.actuate.endpoint.EndpointId;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.ConcurrentReferenceHashMap;

class OnEnabledEndpointCondition
extends AbstractEndpointCondition {
    private static final String ENABLED_BY_DEFAULT_KEY = "management.endpoints.enabled-by-default";
    private static final ConcurrentReferenceHashMap<Environment, Optional<Boolean>> enabledByDefaultCache = new ConcurrentReferenceHashMap();

    OnEnabledEndpointCondition() {
    }

    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        Environment environment = context.getEnvironment();
        AnnotationAttributes attributes = this.getEndpointAttributes(ConditionalOnEnabledEndpoint.class, context, metadata);
        EndpointId id = EndpointId.of((String)attributes.getString("id"));
        String key = "management.endpoint." + id.toLowerCaseString() + ".enabled";
        Boolean userDefinedEnabled = (Boolean)environment.getProperty(key, Boolean.class);
        if (userDefinedEnabled != null) {
            return new ConditionOutcome(userDefinedEnabled.booleanValue(), ConditionMessage.forCondition(ConditionalOnEnabledEndpoint.class, (Object[])new Object[0]).because("found property " + key + " with value " + userDefinedEnabled));
        }
        Boolean userDefinedDefault = this.isEnabledByDefault(environment);
        if (userDefinedDefault != null) {
            return new ConditionOutcome(userDefinedDefault.booleanValue(), ConditionMessage.forCondition(ConditionalOnEnabledEndpoint.class, (Object[])new Object[0]).because("no property " + key + " found so using user defined default from " + ENABLED_BY_DEFAULT_KEY));
        }
        boolean endpointDefault = attributes.getBoolean("enableByDefault");
        return new ConditionOutcome(endpointDefault, ConditionMessage.forCondition(ConditionalOnEnabledEndpoint.class, (Object[])new Object[0]).because("no property " + key + " found so using endpoint default"));
    }

    private Boolean isEnabledByDefault(Environment environment) {
        Optional<Object> enabledByDefault = (Optional<Object>)enabledByDefaultCache.get((Object)environment);
        if (enabledByDefault == null) {
            enabledByDefault = Optional.ofNullable(environment.getProperty(ENABLED_BY_DEFAULT_KEY, Boolean.class));
            enabledByDefaultCache.put((Object)environment, enabledByDefault);
        }
        return enabledByDefault.orElse(null);
    }
}

