/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.endpoint.condition;

import java.util.Map;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.EndpointExtension;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.core.type.MethodMetadata;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

abstract class AbstractEndpointCondition
extends SpringBootCondition {
    AbstractEndpointCondition() {
    }

    AnnotationAttributes getEndpointAttributes(Class<?> annotationClass, ConditionContext context, AnnotatedTypeMetadata metadata) {
        return this.getEndpointAttributes(this.getEndpointType(annotationClass, context, metadata));
    }

    Class<?> getEndpointType(Class<?> annotationClass, ConditionContext context, AnnotatedTypeMetadata metadata) {
        Class target;
        Map attributes = metadata.getAnnotationAttributes(annotationClass.getName());
        if (attributes != null && attributes.containsKey("endpoint") && (target = (Class)attributes.get("endpoint")) != Void.class) {
            return target;
        }
        Assert.state((metadata instanceof MethodMetadata && metadata.isAnnotated(Bean.class.getName()) ? 1 : 0) != 0, (String)"EndpointCondition must be used on @Bean methods when the endpoint is not specified");
        MethodMetadata methodMetadata = (MethodMetadata)metadata;
        try {
            return ClassUtils.forName((String)methodMetadata.getReturnTypeName(), (ClassLoader)context.getClassLoader());
        }
        catch (Throwable ex) {
            throw new IllegalStateException("Failed to extract endpoint id for " + methodMetadata.getDeclaringClassName() + "." + methodMetadata.getMethodName(), ex);
        }
    }

    AnnotationAttributes getEndpointAttributes(Class<?> type) {
        AnnotationAttributes attributes = AnnotatedElementUtils.findMergedAnnotationAttributes(type, Endpoint.class, (boolean)true, (boolean)true);
        if (attributes != null) {
            return attributes;
        }
        attributes = AnnotatedElementUtils.findMergedAnnotationAttributes(type, EndpointExtension.class, (boolean)false, (boolean)true);
        Assert.state((attributes != null ? 1 : 0) != 0, (String)"No endpoint is specified and the return type of the @Bean method is neither an @Endpoint, nor an @EndpointExtension");
        return this.getEndpointAttributes(attributes.getClass("endpoint"));
    }
}

