/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.amqp;

import java.util.Map;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.boot.actuate.amqp.RabbitHealthIndicator;
import org.springframework.boot.actuate.autoconfigure.health.CompositeHealthIndicatorConfiguration;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.autoconfigure.health.HealthIndicatorAutoConfiguration;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.amqp.RabbitAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={RabbitTemplate.class})
@ConditionalOnBean(value={RabbitTemplate.class})
@ConditionalOnEnabledHealthIndicator(value="rabbit")
@AutoConfigureBefore(value={HealthIndicatorAutoConfiguration.class})
@AutoConfigureAfter(value={RabbitAutoConfiguration.class})
public class RabbitHealthIndicatorAutoConfiguration
extends CompositeHealthIndicatorConfiguration<RabbitHealthIndicator, RabbitTemplate> {
    @Bean
    @ConditionalOnMissingBean(name={"rabbitHealthIndicator"})
    public HealthIndicator rabbitHealthIndicator(Map<String, RabbitTemplate> rabbitTemplates) {
        return this.createHealthIndicator(rabbitTemplates);
    }
}

