/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.endpoint;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.springframework.boot.actuate.endpoint.EndpointFilter;
import org.springframework.boot.actuate.endpoint.EndpointId;
import org.springframework.boot.actuate.endpoint.ExposableEndpoint;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.core.env.Environment;
import org.springframework.util.Assert;

public class ExposeExcludePropertyEndpointFilter<E extends ExposableEndpoint<?>>
implements EndpointFilter<E> {
    private final Class<E> endpointType;
    private final EndpointPatterns include;
    private final EndpointPatterns exclude;
    private final EndpointPatterns exposeDefaults;

    public ExposeExcludePropertyEndpointFilter(Class<E> endpointType, Environment environment, String prefix, String ... exposeDefaults) {
        Assert.notNull(endpointType, (String)"EndpointType must not be null");
        Assert.notNull((Object)environment, (String)"Environment must not be null");
        Assert.hasText((String)prefix, (String)"Prefix must not be empty");
        Binder binder = Binder.get((Environment)environment);
        this.endpointType = endpointType;
        this.include = new EndpointPatterns(this.bind(binder, prefix + ".include"));
        this.exclude = new EndpointPatterns(this.bind(binder, prefix + ".exclude"));
        this.exposeDefaults = new EndpointPatterns(exposeDefaults);
    }

    public ExposeExcludePropertyEndpointFilter(Class<E> endpointType, Collection<String> include, Collection<String> exclude, String ... exposeDefaults) {
        Assert.notNull(endpointType, (String)"EndpointType Type must not be null");
        this.endpointType = endpointType;
        this.include = new EndpointPatterns(include);
        this.exclude = new EndpointPatterns(exclude);
        this.exposeDefaults = new EndpointPatterns(exposeDefaults);
    }

    private List<String> bind(Binder binder, String name) {
        return (List)binder.bind(name, Bindable.listOf(String.class)).orElseGet(ArrayList::new);
    }

    public boolean match(E endpoint) {
        if (this.endpointType.isInstance(endpoint)) {
            return this.isExposed((ExposableEndpoint<?>)endpoint) && !this.isExcluded((ExposableEndpoint<?>)endpoint);
        }
        return true;
    }

    private boolean isExposed(ExposableEndpoint<?> endpoint) {
        if (this.include.isEmpty()) {
            return this.exposeDefaults.matchesAll() || this.exposeDefaults.matches(endpoint);
        }
        return this.include.matchesAll() || this.include.matches(endpoint);
    }

    private boolean isExcluded(ExposableEndpoint<?> endpoint) {
        if (this.exclude.isEmpty()) {
            return false;
        }
        return this.exclude.matchesAll() || this.exclude.matches(endpoint);
    }

    private static class EndpointPatterns {
        private final boolean empty;
        private final boolean matchesAll;
        private final Set<EndpointId> endpointIds;

        EndpointPatterns(String[] patterns) {
            this(patterns != null ? Arrays.asList(patterns) : (Collection)null);
        }

        EndpointPatterns(Collection<String> patterns) {
            patterns = patterns != null ? patterns : Collections.emptySet();
            boolean matchesAll = false;
            LinkedHashSet<EndpointId> endpointIds = new LinkedHashSet<EndpointId>();
            for (String pattern : patterns) {
                if ("*".equals(pattern)) {
                    matchesAll = true;
                    continue;
                }
                endpointIds.add(EndpointId.fromPropertyValue((String)pattern));
            }
            this.empty = patterns.isEmpty();
            this.matchesAll = matchesAll;
            this.endpointIds = endpointIds;
        }

        boolean isEmpty() {
            return this.empty;
        }

        boolean matchesAll() {
            return this.matchesAll;
        }

        boolean matches(ExposableEndpoint<?> endpoint) {
            return this.endpointIds.contains(endpoint.getEndpointId());
        }
    }
}

